/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about an action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionTypeId implements SdkPojo, Serializable, ToCopyableBuilder<ActionTypeId.Builder, ActionTypeId> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ActionTypeId::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("owner")
            .getter(getter(ActionTypeId::ownerAsString)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(ActionTypeId::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(ActionTypeId::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, OWNER_FIELD,
            PROVIDER_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String owner;

    private final String provider;

    private final String version;

    private ActionTypeId(BuilderImpl builder) {
        this.category = builder.category;
        this.owner = builder.owner;
        this.provider = builder.provider;
        this.version = builder.version;
    }

    /**
     * <p>
     * A category defines what kind of action can be taken in the stage, and constrains the provider type for the
     * action. Valid categories are limited to one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Source
     * </p>
     * </li>
     * <li>
     * <p>
     * Build
     * </p>
     * </li>
     * <li>
     * <p>
     * Test
     * </p>
     * </li>
     * <li>
     * <p>
     * Deploy
     * </p>
     * </li>
     * <li>
     * <p>
     * Invoke
     * </p>
     * </li>
     * <li>
     * <p>
     * Approval
     * </p>
     * </li>
     * <li>
     * <p>
     * Compute
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return A category defines what kind of action can be taken in the stage, and constrains the provider type for
     *         the action. Valid categories are limited to one of the following values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Source
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Build
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Test
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deploy
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Invoke
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Approval
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Compute
     *         </p>
     *         </li>
     * @see ActionCategory
     */
    public final ActionCategory category() {
        return ActionCategory.fromValue(category);
    }

    /**
     * <p>
     * A category defines what kind of action can be taken in the stage, and constrains the provider type for the
     * action. Valid categories are limited to one of the following values.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Source
     * </p>
     * </li>
     * <li>
     * <p>
     * Build
     * </p>
     * </li>
     * <li>
     * <p>
     * Test
     * </p>
     * </li>
     * <li>
     * <p>
     * Deploy
     * </p>
     * </li>
     * <li>
     * <p>
     * Invoke
     * </p>
     * </li>
     * <li>
     * <p>
     * Approval
     * </p>
     * </li>
     * <li>
     * <p>
     * Compute
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ActionCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return A category defines what kind of action can be taken in the stage, and constrains the provider type for
     *         the action. Valid categories are limited to one of the following values. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Source
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Build
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Test
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deploy
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Invoke
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Approval
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Compute
     *         </p>
     *         </li>
     * @see ActionCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The creator of the action being called. There are three valid values for the <code>Owner</code> field in the
     * action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and
     * <code>Custom</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     * >Valid Action Types and Providers in CodePipeline</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link ActionOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The creator of the action being called. There are three valid values for the <code>Owner</code> field in
     *         the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>,
     *         and <code>Custom</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     *         >Valid Action Types and Providers in CodePipeline</a>.
     * @see ActionOwner
     */
    public final ActionOwner owner() {
        return ActionOwner.fromValue(owner);
    }

    /**
     * <p>
     * The creator of the action being called. There are three valid values for the <code>Owner</code> field in the
     * action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and
     * <code>Custom</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     * >Valid Action Types and Providers in CodePipeline</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #owner} will return
     * {@link ActionOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ownerAsString}.
     * </p>
     * 
     * @return The creator of the action being called. There are three valid values for the <code>Owner</code> field in
     *         the action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>,
     *         and <code>Custom</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     *         >Valid Action Types and Providers in CodePipeline</a>.
     * @see ActionOwner
     */
    public final String ownerAsString() {
        return owner;
    }

    /**
     * <p>
     * The provider of the service being called by the action. Valid providers are determined by the action category.
     * For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified
     * as <code>CodeDeploy</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     * >Valid Action Types and Providers in CodePipeline</a>.
     * </p>
     * 
     * @return The provider of the service being called by the action. Valid providers are determined by the action
     *         category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which
     *         would be specified as <code>CodeDeploy</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
     *         >Valid Action Types and Providers in CodePipeline</a>.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * A string that describes the action version.
     * </p>
     * 
     * @return A string that describes the action version.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionTypeId)) {
            return false;
        }
        ActionTypeId other = (ActionTypeId) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(ownerAsString(), other.ownerAsString()) && Objects.equals(provider(), other.provider())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionTypeId").add("Category", categoryAsString()).add("Owner", ownerAsString())
                .add("Provider", provider()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(ownerAsString()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("category", CATEGORY_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionTypeId, T> g) {
        return obj -> g.apply((ActionTypeId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionTypeId> {
        /**
         * <p>
         * A category defines what kind of action can be taken in the stage, and constrains the provider type for the
         * action. Valid categories are limited to one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source
         * </p>
         * </li>
         * <li>
         * <p>
         * Build
         * </p>
         * </li>
         * <li>
         * <p>
         * Test
         * </p>
         * </li>
         * <li>
         * <p>
         * Deploy
         * </p>
         * </li>
         * <li>
         * <p>
         * Invoke
         * </p>
         * </li>
         * <li>
         * <p>
         * Approval
         * </p>
         * </li>
         * <li>
         * <p>
         * Compute
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        A category defines what kind of action can be taken in the stage, and constrains the provider type for
         *        the action. Valid categories are limited to one of the following values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Build
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Test
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deploy
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Invoke
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Approval
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Compute
         *        </p>
         *        </li>
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(String category);

        /**
         * <p>
         * A category defines what kind of action can be taken in the stage, and constrains the provider type for the
         * action. Valid categories are limited to one of the following values.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Source
         * </p>
         * </li>
         * <li>
         * <p>
         * Build
         * </p>
         * </li>
         * <li>
         * <p>
         * Test
         * </p>
         * </li>
         * <li>
         * <p>
         * Deploy
         * </p>
         * </li>
         * <li>
         * <p>
         * Invoke
         * </p>
         * </li>
         * <li>
         * <p>
         * Approval
         * </p>
         * </li>
         * <li>
         * <p>
         * Compute
         * </p>
         * </li>
         * </ul>
         * 
         * @param category
         *        A category defines what kind of action can be taken in the stage, and constrains the provider type for
         *        the action. Valid categories are limited to one of the following values. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Source
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Build
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Test
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deploy
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Invoke
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Approval
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Compute
         *        </p>
         *        </li>
         * @see ActionCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionCategory
         */
        Builder category(ActionCategory category);

        /**
         * <p>
         * The creator of the action being called. There are three valid values for the <code>Owner</code> field in the
         * action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and
         * <code>Custom</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         * >Valid Action Types and Providers in CodePipeline</a>.
         * </p>
         * 
         * @param owner
         *        The creator of the action being called. There are three valid values for the <code>Owner</code> field
         *        in the action category section within your pipeline structure: <code>AWS</code>,
         *        <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         *        >Valid Action Types and Providers in CodePipeline</a>.
         * @see ActionOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOwner
         */
        Builder owner(String owner);

        /**
         * <p>
         * The creator of the action being called. There are three valid values for the <code>Owner</code> field in the
         * action category section within your pipeline structure: <code>AWS</code>, <code>ThirdParty</code>, and
         * <code>Custom</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         * >Valid Action Types and Providers in CodePipeline</a>.
         * </p>
         * 
         * @param owner
         *        The creator of the action being called. There are three valid values for the <code>Owner</code> field
         *        in the action category section within your pipeline structure: <code>AWS</code>,
         *        <code>ThirdParty</code>, and <code>Custom</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         *        >Valid Action Types and Providers in CodePipeline</a>.
         * @see ActionOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionOwner
         */
        Builder owner(ActionOwner owner);

        /**
         * <p>
         * The provider of the service being called by the action. Valid providers are determined by the action
         * category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would
         * be specified as <code>CodeDeploy</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         * >Valid Action Types and Providers in CodePipeline</a>.
         * </p>
         * 
         * @param provider
         *        The provider of the service being called by the action. Valid providers are determined by the action
         *        category. For example, an action in the Deploy category type might have a provider of CodeDeploy,
         *        which would be specified as <code>CodeDeploy</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers"
         *        >Valid Action Types and Providers in CodePipeline</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * A string that describes the action version.
         * </p>
         * 
         * @param version
         *        A string that describes the action version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String owner;

        private String provider;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionTypeId model) {
            category(model.category);
            owner(model.owner);
            provider(model.provider);
            version(model.version);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public final Builder owner(ActionOwner owner) {
            this.owner(owner == null ? null : owner.toString());
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ActionTypeId build() {
            return new ActionTypeId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
