/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The condition for the stage. A condition is made up of the rules and the result for the condition. For more
 * information about conditions, see <a
 * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a>. For more
 * information about rules, see the <a
 * href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">CodePipeline rule reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(Condition::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<List<RuleDeclaration>> RULES_FIELD = SdkField
            .<List<RuleDeclaration>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(Condition::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String result;

    private final List<RuleDeclaration> rules;

    private Condition(BuilderImpl builder) {
        this.result = builder.result;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The action to be done when the condition is met. For example, rolling back an execution for a failure condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link Result#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The action to be done when the condition is met. For example, rolling back an execution for a failure
     *         condition.
     * @see Result
     */
    public final Result result() {
        return Result.fromValue(result);
    }

    /**
     * <p>
     * The action to be done when the condition is met. For example, rolling back an execution for a failure condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link Result#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The action to be done when the condition is met. For example, rolling back an execution for a failure
     *         condition.
     * @see Result
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules that make up the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules that make up the condition.
     */
    public final List<RuleDeclaration> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(resultAsString(), other.resultAsString()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("Result", resultAsString()).add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("result", RESULT_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * The action to be done when the condition is met. For example, rolling back an execution for a failure
         * condition.
         * </p>
         * 
         * @param result
         *        The action to be done when the condition is met. For example, rolling back an execution for a failure
         *        condition.
         * @see Result
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Result
         */
        Builder result(String result);

        /**
         * <p>
         * The action to be done when the condition is met. For example, rolling back an execution for a failure
         * condition.
         * </p>
         * 
         * @param result
         *        The action to be done when the condition is met. For example, rolling back an execution for a failure
         *        condition.
         * @see Result
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Result
         */
        Builder result(Result result);

        /**
         * <p>
         * The rules that make up the condition.
         * </p>
         * 
         * @param rules
         *        The rules that make up the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RuleDeclaration> rules);

        /**
         * <p>
         * The rules that make up the condition.
         * </p>
         * 
         * @param rules
         *        The rules that make up the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RuleDeclaration... rules);

        /**
         * <p>
         * The rules that make up the condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleDeclaration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codepipeline.model.RuleDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<RuleDeclaration>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.RuleDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<RuleDeclaration>)
         */
        Builder rules(Consumer<RuleDeclaration.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String result;

        private List<RuleDeclaration> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            result(model.result);
            rules(model.rules);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(Result result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final List<RuleDeclaration.Builder> getRules() {
            List<RuleDeclaration.Builder> result = RuleDeclarationListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleDeclaration.BuilderImpl> rules) {
            this.rules = RuleDeclarationListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RuleDeclaration> rules) {
            this.rules = RuleDeclarationListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleDeclaration... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleDeclaration.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RuleDeclaration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
