/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActionExecutionsResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListActionExecutionsResponse.Builder, ListActionExecutionsResponse> {
    private static final SdkField<List<ActionExecutionDetail>> ACTION_EXECUTION_DETAILS_FIELD = SdkField
            .<List<ActionExecutionDetail>> builder(MarshallingType.LIST)
            .memberName("actionExecutionDetails")
            .getter(getter(ListActionExecutionsResponse::actionExecutionDetails))
            .setter(setter(Builder::actionExecutionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionExecutionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionExecutionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListActionExecutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTION_EXECUTION_DETAILS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ActionExecutionDetail> actionExecutionDetails;

    private final String nextToken;

    private ListActionExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionExecutionDetails = builder.actionExecutionDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionExecutionDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasActionExecutionDetails() {
        return actionExecutionDetails != null && !(actionExecutionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for a list of recent executions, such as action execution ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionExecutionDetails} method.
     * </p>
     * 
     * @return The details for a list of recent executions, such as action execution ID.
     */
    public final List<ActionExecutionDetail> actionExecutionDetails() {
        return actionExecutionDetails;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an identifier is also returned and can be used in a
     * subsequent <code>ListActionExecutions</code> call to return the next set of action executions in the list.
     * </p>
     * 
     * @return If the amount of returned information is significantly large, an identifier is also returned and can be
     *         used in a subsequent <code>ListActionExecutions</code> call to return the next set of action executions
     *         in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionExecutionDetails() ? actionExecutionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionExecutionsResponse)) {
            return false;
        }
        ListActionExecutionsResponse other = (ListActionExecutionsResponse) obj;
        return hasActionExecutionDetails() == other.hasActionExecutionDetails()
                && Objects.equals(actionExecutionDetails(), other.actionExecutionDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListActionExecutionsResponse")
                .add("ActionExecutionDetails", hasActionExecutionDetails() ? actionExecutionDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionExecutionDetails":
            return Optional.ofNullable(clazz.cast(actionExecutionDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionExecutionDetails", ACTION_EXECUTION_DETAILS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionExecutionsResponse, T> g) {
        return obj -> g.apply((ListActionExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListActionExecutionsResponse> {
        /**
         * <p>
         * The details for a list of recent executions, such as action execution ID.
         * </p>
         * 
         * @param actionExecutionDetails
         *        The details for a list of recent executions, such as action execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionDetails(Collection<ActionExecutionDetail> actionExecutionDetails);

        /**
         * <p>
         * The details for a list of recent executions, such as action execution ID.
         * </p>
         * 
         * @param actionExecutionDetails
         *        The details for a list of recent executions, such as action execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionExecutionDetails(ActionExecutionDetail... actionExecutionDetails);

        /**
         * <p>
         * The details for a list of recent executions, such as action execution ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #actionExecutionDetails(List<ActionExecutionDetail>)}.
         * 
         * @param actionExecutionDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionExecutionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionExecutionDetails(java.util.Collection<ActionExecutionDetail>)
         */
        Builder actionExecutionDetails(Consumer<ActionExecutionDetail.Builder>... actionExecutionDetails);

        /**
         * <p>
         * If the amount of returned information is significantly large, an identifier is also returned and can be used
         * in a subsequent <code>ListActionExecutions</code> call to return the next set of action executions in the
         * list.
         * </p>
         * 
         * @param nextToken
         *        If the amount of returned information is significantly large, an identifier is also returned and can
         *        be used in a subsequent <code>ListActionExecutions</code> call to return the next set of action
         *        executions in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<ActionExecutionDetail> actionExecutionDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionExecutionsResponse model) {
            super(model);
            actionExecutionDetails(model.actionExecutionDetails);
            nextToken(model.nextToken);
        }

        public final List<ActionExecutionDetail.Builder> getActionExecutionDetails() {
            List<ActionExecutionDetail.Builder> result = ActionExecutionDetailListCopier
                    .copyToBuilder(this.actionExecutionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionExecutionDetails(Collection<ActionExecutionDetail.BuilderImpl> actionExecutionDetails) {
            this.actionExecutionDetails = ActionExecutionDetailListCopier.copyFromBuilder(actionExecutionDetails);
        }

        @Override
        public final Builder actionExecutionDetails(Collection<ActionExecutionDetail> actionExecutionDetails) {
            this.actionExecutionDetails = ActionExecutionDetailListCopier.copy(actionExecutionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionExecutionDetails(ActionExecutionDetail... actionExecutionDetails) {
            actionExecutionDetails(Arrays.asList(actionExecutionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionExecutionDetails(Consumer<ActionExecutionDetail.Builder>... actionExecutionDetails) {
            actionExecutionDetails(Stream.of(actionExecutionDetails)
                    .map(c -> ActionExecutionDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActionExecutionsResponse build() {
            return new ListActionExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
