/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRuleTypesRequest extends CodePipelineRequest implements
        ToCopyableBuilder<ListRuleTypesRequest.Builder, ListRuleTypesRequest> {
    private static final SdkField<String> RULE_OWNER_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleOwnerFilter").getter(getter(ListRuleTypesRequest::ruleOwnerFilterAsString))
            .setter(setter(Builder::ruleOwnerFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleOwnerFilter").build()).build();

    private static final SdkField<String> REGION_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionFilter").getter(getter(ListRuleTypesRequest::regionFilter)).setter(setter(Builder::regionFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_OWNER_FILTER_FIELD,
            REGION_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleOwnerFilter;

    private final String regionFilter;

    private ListRuleTypesRequest(BuilderImpl builder) {
        super(builder);
        this.ruleOwnerFilter = builder.ruleOwnerFilter;
        this.regionFilter = builder.regionFilter;
    }

    /**
     * <p>
     * The rule owner to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOwnerFilter}
     * will return {@link RuleOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOwnerFilterAsString}.
     * </p>
     * 
     * @return The rule owner to filter on.
     * @see RuleOwner
     */
    public final RuleOwner ruleOwnerFilter() {
        return RuleOwner.fromValue(ruleOwnerFilter);
    }

    /**
     * <p>
     * The rule owner to filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleOwnerFilter}
     * will return {@link RuleOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleOwnerFilterAsString}.
     * </p>
     * 
     * @return The rule owner to filter on.
     * @see RuleOwner
     */
    public final String ruleOwnerFilterAsString() {
        return ruleOwnerFilter;
    }

    /**
     * <p>
     * The rule Region to filter on.
     * </p>
     * 
     * @return The rule Region to filter on.
     */
    public final String regionFilter() {
        return regionFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleOwnerFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleTypesRequest)) {
            return false;
        }
        ListRuleTypesRequest other = (ListRuleTypesRequest) obj;
        return Objects.equals(ruleOwnerFilterAsString(), other.ruleOwnerFilterAsString())
                && Objects.equals(regionFilter(), other.regionFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRuleTypesRequest").add("RuleOwnerFilter", ruleOwnerFilterAsString())
                .add("RegionFilter", regionFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleOwnerFilter":
            return Optional.ofNullable(clazz.cast(ruleOwnerFilterAsString()));
        case "regionFilter":
            return Optional.ofNullable(clazz.cast(regionFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleOwnerFilter", RULE_OWNER_FILTER_FIELD);
        map.put("regionFilter", REGION_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRuleTypesRequest, T> g) {
        return obj -> g.apply((ListRuleTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRuleTypesRequest> {
        /**
         * <p>
         * The rule owner to filter on.
         * </p>
         * 
         * @param ruleOwnerFilter
         *        The rule owner to filter on.
         * @see RuleOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOwner
         */
        Builder ruleOwnerFilter(String ruleOwnerFilter);

        /**
         * <p>
         * The rule owner to filter on.
         * </p>
         * 
         * @param ruleOwnerFilter
         *        The rule owner to filter on.
         * @see RuleOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOwner
         */
        Builder ruleOwnerFilter(RuleOwner ruleOwnerFilter);

        /**
         * <p>
         * The rule Region to filter on.
         * </p>
         * 
         * @param regionFilter
         *        The rule Region to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionFilter(String regionFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String ruleOwnerFilter;

        private String regionFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleTypesRequest model) {
            super(model);
            ruleOwnerFilter(model.ruleOwnerFilter);
            regionFilter(model.regionFilter);
        }

        public final String getRuleOwnerFilter() {
            return ruleOwnerFilter;
        }

        public final void setRuleOwnerFilter(String ruleOwnerFilter) {
            this.ruleOwnerFilter = ruleOwnerFilter;
        }

        @Override
        public final Builder ruleOwnerFilter(String ruleOwnerFilter) {
            this.ruleOwnerFilter = ruleOwnerFilter;
            return this;
        }

        @Override
        public final Builder ruleOwnerFilter(RuleOwner ruleOwnerFilter) {
            this.ruleOwnerFilter(ruleOwnerFilter == null ? null : ruleOwnerFilter.toString());
            return this;
        }

        public final String getRegionFilter() {
            return regionFilter;
        }

        public final void setRegionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
        }

        @Override
        public final Builder regionFilter(String regionFilter) {
            this.regionFilter = regionFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRuleTypesRequest build() {
            return new ListRuleTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
