/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pipeline execution to filter on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineExecutionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineExecutionFilter.Builder, PipelineExecutionFilter> {
    private static final SdkField<SucceededInStageFilter> SUCCEEDED_IN_STAGE_FIELD = SdkField
            .<SucceededInStageFilter> builder(MarshallingType.SDK_POJO).memberName("succeededInStage")
            .getter(getter(PipelineExecutionFilter::succeededInStage)).setter(setter(Builder::succeededInStage))
            .constructor(SucceededInStageFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeededInStage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_IN_STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SucceededInStageFilter succeededInStage;

    private PipelineExecutionFilter(BuilderImpl builder) {
        this.succeededInStage = builder.succeededInStage;
    }

    /**
     * <p>
     * Filter for pipeline executions where the stage was successful in the current pipeline version.
     * </p>
     * 
     * @return Filter for pipeline executions where the stage was successful in the current pipeline version.
     */
    public final SucceededInStageFilter succeededInStage() {
        return succeededInStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(succeededInStage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionFilter)) {
            return false;
        }
        PipelineExecutionFilter other = (PipelineExecutionFilter) obj;
        return Objects.equals(succeededInStage(), other.succeededInStage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineExecutionFilter").add("SucceededInStage", succeededInStage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "succeededInStage":
            return Optional.ofNullable(clazz.cast(succeededInStage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("succeededInStage", SUCCEEDED_IN_STAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionFilter, T> g) {
        return obj -> g.apply((PipelineExecutionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineExecutionFilter> {
        /**
         * <p>
         * Filter for pipeline executions where the stage was successful in the current pipeline version.
         * </p>
         * 
         * @param succeededInStage
         *        Filter for pipeline executions where the stage was successful in the current pipeline version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeededInStage(SucceededInStageFilter succeededInStage);

        /**
         * <p>
         * Filter for pipeline executions where the stage was successful in the current pipeline version.
         * </p>
         * This is a convenience method that creates an instance of the {@link SucceededInStageFilter.Builder} avoiding
         * the need to create one manually via {@link SucceededInStageFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SucceededInStageFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #succeededInStage(SucceededInStageFilter)}.
         * 
         * @param succeededInStage
         *        a consumer that will call methods on {@link SucceededInStageFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #succeededInStage(SucceededInStageFilter)
         */
        default Builder succeededInStage(Consumer<SucceededInStageFilter.Builder> succeededInStage) {
            return succeededInStage(SucceededInStageFilter.builder().applyMutation(succeededInStage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SucceededInStageFilter succeededInStage;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionFilter model) {
            succeededInStage(model.succeededInStage);
        }

        public final SucceededInStageFilter.Builder getSucceededInStage() {
            return succeededInStage != null ? succeededInStage.toBuilder() : null;
        }

        public final void setSucceededInStage(SucceededInStageFilter.BuilderImpl succeededInStage) {
            this.succeededInStage = succeededInStage != null ? succeededInStage.build() : null;
        }

        @Override
        public final Builder succeededInStage(SucceededInStageFilter succeededInStage) {
            this.succeededInStage = succeededInStage;
            return this;
        }

        @Override
        public PipelineExecutionFilter build() {
            return new PipelineExecutionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
