/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutThirdPartyJobFailureResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutThirdPartyJobFailureResultRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutThirdPartyJobFailureResultRequest.Builder, PutThirdPartyJobFailureResultRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(PutThirdPartyJobFailureResultRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(PutThirdPartyJobFailureResultRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField
            .<FailureDetails> builder(MarshallingType.SDK_POJO).memberName("failureDetails")
            .getter(getter(PutThirdPartyJobFailureResultRequest::failureDetails)).setter(setter(Builder::failureDetails))
            .constructor(FailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            CLIENT_TOKEN_FIELD, FAILURE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String clientToken;

    private final FailureDetails failureDetails;

    private PutThirdPartyJobFailureResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.clientToken = builder.clientToken;
        this.failureDetails = builder.failureDetails;
    }

    /**
     * <p>
     * The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.
     * </p>
     * 
     * @return The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed
     * access to the job and its details.
     * </p>
     * 
     * @return The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
     *         allowed access to the job and its details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Represents information about failure details.
     * </p>
     * 
     * @return Represents information about failure details.
     */
    public final FailureDetails failureDetails() {
        return failureDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(failureDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutThirdPartyJobFailureResultRequest)) {
            return false;
        }
        PutThirdPartyJobFailureResultRequest other = (PutThirdPartyJobFailureResultRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(failureDetails(), other.failureDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutThirdPartyJobFailureResultRequest").add("JobId", jobId()).add("ClientToken", clientToken())
                .add("FailureDetails", failureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "failureDetails":
            return Optional.ofNullable(clazz.cast(failureDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("failureDetails", FAILURE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutThirdPartyJobFailureResultRequest, T> g) {
        return obj -> g.apply((PutThirdPartyJobFailureResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutThirdPartyJobFailureResultRequest> {
        /**
         * <p>
         * The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.
         * </p>
         * 
         * @param jobId
         *        The ID of the job that failed. This is the same ID returned from <code>PollForThirdPartyJobs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
         * allowed access to the job and its details.
         * </p>
         * 
         * @param clientToken
         *        The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is
         *        allowed access to the job and its details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Represents information about failure details.
         * </p>
         * 
         * @param failureDetails
         *        Represents information about failure details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(FailureDetails failureDetails);

        /**
         * <p>
         * Represents information about failure details.
         * </p>
         * This is a convenience method that creates an instance of the {@link FailureDetails.Builder} avoiding the need
         * to create one manually via {@link FailureDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #failureDetails(FailureDetails)}.
         * 
         * @param failureDetails
         *        a consumer that will call methods on {@link FailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDetails(FailureDetails)
         */
        default Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return failureDetails(FailureDetails.builder().applyMutation(failureDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String jobId;

        private String clientToken;

        private FailureDetails failureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PutThirdPartyJobFailureResultRequest model) {
            super(model);
            jobId(model.jobId);
            clientToken(model.clientToken);
            failureDetails(model.failureDetails);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return failureDetails != null ? failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutThirdPartyJobFailureResultRequest build() {
            return new PutThirdPartyJobFailureResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
