/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about each time a rule is run as part of the pipeline execution for a pipeline configured with
 * conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleExecution implements SdkPojo, Serializable, ToCopyableBuilder<RuleExecution.Builder, RuleExecution> {
    private static final SdkField<String> RULE_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleExecutionId").getter(getter(RuleExecution::ruleExecutionId))
            .setter(setter(Builder::ruleExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RuleExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(RuleExecution::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChange").getter(getter(RuleExecution::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(RuleExecution::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(RuleExecution::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionId").getter(getter(RuleExecution::externalExecutionId))
            .setter(setter(Builder::externalExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionUrl").getter(getter(RuleExecution::externalExecutionUrl))
            .setter(setter(Builder::externalExecutionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionUrl").build())
            .build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("errorDetails").getter(getter(RuleExecution::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_EXECUTION_ID_FIELD,
            STATUS_FIELD, SUMMARY_FIELD, LAST_STATUS_CHANGE_FIELD, TOKEN_FIELD, LAST_UPDATED_BY_FIELD,
            EXTERNAL_EXECUTION_ID_FIELD, EXTERNAL_EXECUTION_URL_FIELD, ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleExecutionId;

    private final String status;

    private final String summary;

    private final Instant lastStatusChange;

    private final String token;

    private final String lastUpdatedBy;

    private final String externalExecutionId;

    private final String externalExecutionUrl;

    private final ErrorDetails errorDetails;

    private RuleExecution(BuilderImpl builder) {
        this.ruleExecutionId = builder.ruleExecutionId;
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
        this.token = builder.token;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The execution ID for the run of the rule.
     * </p>
     * 
     * @return The execution ID for the run of the rule.
     */
    public final String ruleExecutionId() {
        return ruleExecutionId;
    }

    /**
     * <p>
     * The status of the run of the rule, such as FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the run of the rule, such as FAILED.
     * @see RuleExecutionStatus
     */
    public final RuleExecutionStatus status() {
        return RuleExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the run of the rule, such as FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the run of the rule, such as FAILED.
     * @see RuleExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A summary of the run of the rule.
     * </p>
     * 
     * @return A summary of the run of the rule.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * The last status change of the rule.
     * </p>
     * 
     * @return The last status change of the rule.
     */
    public final Instant lastStatusChange() {
        return lastStatusChange;
    }

    /**
     * <p>
     * The system-generated token used to identify a unique request.
     * </p>
     * 
     * @return The system-generated token used to identify a unique request.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * The ARN of the user who last changed the rule.
     * </p>
     * 
     * @return The ARN of the user who last changed the rule.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The external ID of the run of the rule.
     * </p>
     * 
     * @return The external ID of the run of the rule.
     */
    public final String externalExecutionId() {
        return externalExecutionId;
    }

    /**
     * <p>
     * The URL of a resource external to Amazon Web Services that is used when running the rule (for example, an
     * external repository URL).
     * </p>
     * 
     * @return The URL of a resource external to Amazon Web Services that is used when running the rule (for example, an
     *         external repository URL).
     */
    public final String externalExecutionUrl() {
        return externalExecutionUrl;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleExecution)) {
            return false;
        }
        RuleExecution other = (RuleExecution) obj;
        return Objects.equals(ruleExecutionId(), other.ruleExecutionId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary())
                && Objects.equals(lastStatusChange(), other.lastStatusChange()) && Objects.equals(token(), other.token())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && Objects.equals(externalExecutionId(), other.externalExecutionId())
                && Objects.equals(externalExecutionUrl(), other.externalExecutionUrl())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleExecution").add("RuleExecutionId", ruleExecutionId()).add("Status", statusAsString())
                .add("Summary", summary()).add("LastStatusChange", lastStatusChange()).add("Token", token())
                .add("LastUpdatedBy", lastUpdatedBy()).add("ExternalExecutionId", externalExecutionId())
                .add("ExternalExecutionUrl", externalExecutionUrl()).add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleExecutionId":
            return Optional.ofNullable(clazz.cast(ruleExecutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "lastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "externalExecutionId":
            return Optional.ofNullable(clazz.cast(externalExecutionId()));
        case "externalExecutionUrl":
            return Optional.ofNullable(clazz.cast(externalExecutionUrl()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleExecutionId", RULE_EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("lastStatusChange", LAST_STATUS_CHANGE_FIELD);
        map.put("token", TOKEN_FIELD);
        map.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("externalExecutionId", EXTERNAL_EXECUTION_ID_FIELD);
        map.put("externalExecutionUrl", EXTERNAL_EXECUTION_URL_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleExecution, T> g) {
        return obj -> g.apply((RuleExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleExecution> {
        /**
         * <p>
         * The execution ID for the run of the rule.
         * </p>
         * 
         * @param ruleExecutionId
         *        The execution ID for the run of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleExecutionId(String ruleExecutionId);

        /**
         * <p>
         * The status of the run of the rule, such as FAILED.
         * </p>
         * 
         * @param status
         *        The status of the run of the rule, such as FAILED.
         * @see RuleExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the run of the rule, such as FAILED.
         * </p>
         * 
         * @param status
         *        The status of the run of the rule, such as FAILED.
         * @see RuleExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionStatus
         */
        Builder status(RuleExecutionStatus status);

        /**
         * <p>
         * A summary of the run of the rule.
         * </p>
         * 
         * @param summary
         *        A summary of the run of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * The last status change of the rule.
         * </p>
         * 
         * @param lastStatusChange
         *        The last status change of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);

        /**
         * <p>
         * The system-generated token used to identify a unique request.
         * </p>
         * 
         * @param token
         *        The system-generated token used to identify a unique request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The ARN of the user who last changed the rule.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The ARN of the user who last changed the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The external ID of the run of the rule.
         * </p>
         * 
         * @param externalExecutionId
         *        The external ID of the run of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionId(String externalExecutionId);

        /**
         * <p>
         * The URL of a resource external to Amazon Web Services that is used when running the rule (for example, an
         * external repository URL).
         * </p>
         * 
         * @param externalExecutionUrl
         *        The URL of a resource external to Amazon Web Services that is used when running the rule (for example,
         *        an external repository URL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionUrl(String externalExecutionUrl);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ruleExecutionId;

        private String status;

        private String summary;

        private Instant lastStatusChange;

        private String token;

        private String lastUpdatedBy;

        private String externalExecutionId;

        private String externalExecutionUrl;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleExecution model) {
            ruleExecutionId(model.ruleExecutionId);
            status(model.status);
            summary(model.summary);
            lastStatusChange(model.lastStatusChange);
            token(model.token);
            lastUpdatedBy(model.lastUpdatedBy);
            externalExecutionId(model.externalExecutionId);
            externalExecutionUrl(model.externalExecutionUrl);
            errorDetails(model.errorDetails);
        }

        public final String getRuleExecutionId() {
            return ruleExecutionId;
        }

        public final void setRuleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
        }

        @Override
        public final Builder ruleExecutionId(String ruleExecutionId) {
            this.ruleExecutionId = ruleExecutionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getExternalExecutionId() {
            return externalExecutionId;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final String getExternalExecutionUrl() {
            return externalExecutionUrl;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public RuleExecution build() {
            return new RuleExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
