/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of a run of a condition for a stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageConditionState implements SdkPojo, Serializable,
        ToCopyableBuilder<StageConditionState.Builder, StageConditionState> {
    private static final SdkField<StageConditionsExecution> LATEST_EXECUTION_FIELD = SdkField
            .<StageConditionsExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(StageConditionState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(StageConditionsExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final SdkField<List<ConditionState>> CONDITION_STATES_FIELD = SdkField
            .<List<ConditionState>> builder(MarshallingType.LIST)
            .memberName("conditionStates")
            .getter(getter(StageConditionState::conditionStates))
            .setter(setter(Builder::conditionStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConditionState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConditionState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_EXECUTION_FIELD,
            CONDITION_STATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StageConditionsExecution latestExecution;

    private final List<ConditionState> conditionStates;

    private StageConditionState(BuilderImpl builder) {
        this.latestExecution = builder.latestExecution;
        this.conditionStates = builder.conditionStates;
    }

    /**
     * <p>
     * Represents information about the latest run of a condition for a stage.
     * </p>
     * 
     * @return Represents information about the latest run of a condition for a stage.
     */
    public final StageConditionsExecution latestExecution() {
        return latestExecution;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConditionStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConditionStates() {
        return conditionStates != null && !(conditionStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states of the conditions for a run of a condition for a stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionStates} method.
     * </p>
     * 
     * @return The states of the conditions for a run of a condition for a stage.
     */
    public final List<ConditionState> conditionStates() {
        return conditionStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionStates() ? conditionStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageConditionState)) {
            return false;
        }
        StageConditionState other = (StageConditionState) obj;
        return Objects.equals(latestExecution(), other.latestExecution()) && hasConditionStates() == other.hasConditionStates()
                && Objects.equals(conditionStates(), other.conditionStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageConditionState").add("LatestExecution", latestExecution())
                .add("ConditionStates", hasConditionStates() ? conditionStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        case "conditionStates":
            return Optional.ofNullable(clazz.cast(conditionStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("conditionStates", CONDITION_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StageConditionState, T> g) {
        return obj -> g.apply((StageConditionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageConditionState> {
        /**
         * <p>
         * Represents information about the latest run of a condition for a stage.
         * </p>
         * 
         * @param latestExecution
         *        Represents information about the latest run of a condition for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(StageConditionsExecution latestExecution);

        /**
         * <p>
         * Represents information about the latest run of a condition for a stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageConditionsExecution.Builder}
         * avoiding the need to create one manually via {@link StageConditionsExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageConditionsExecution.Builder#build()} is called immediately
         * and its result is passed to {@link #latestExecution(StageConditionsExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link StageConditionsExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(StageConditionsExecution)
         */
        default Builder latestExecution(Consumer<StageConditionsExecution.Builder> latestExecution) {
            return latestExecution(StageConditionsExecution.builder().applyMutation(latestExecution).build());
        }

        /**
         * <p>
         * The states of the conditions for a run of a condition for a stage.
         * </p>
         * 
         * @param conditionStates
         *        The states of the conditions for a run of a condition for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionStates(Collection<ConditionState> conditionStates);

        /**
         * <p>
         * The states of the conditions for a run of a condition for a stage.
         * </p>
         * 
         * @param conditionStates
         *        The states of the conditions for a run of a condition for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionStates(ConditionState... conditionStates);

        /**
         * <p>
         * The states of the conditions for a run of a condition for a stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ConditionState.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.ConditionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ConditionState.Builder#build()} is called
         * immediately and its result is passed to {@link #conditionStates(List<ConditionState>)}.
         * 
         * @param conditionStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ConditionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionStates(java.util.Collection<ConditionState>)
         */
        Builder conditionStates(Consumer<ConditionState.Builder>... conditionStates);
    }

    static final class BuilderImpl implements Builder {
        private StageConditionsExecution latestExecution;

        private List<ConditionState> conditionStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StageConditionState model) {
            latestExecution(model.latestExecution);
            conditionStates(model.conditionStates);
        }

        public final StageConditionsExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(StageConditionsExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(StageConditionsExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final List<ConditionState.Builder> getConditionStates() {
            List<ConditionState.Builder> result = ConditionStateListCopier.copyToBuilder(this.conditionStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionStates(Collection<ConditionState.BuilderImpl> conditionStates) {
            this.conditionStates = ConditionStateListCopier.copyFromBuilder(conditionStates);
        }

        @Override
        public final Builder conditionStates(Collection<ConditionState> conditionStates) {
            this.conditionStates = ConditionStateListCopier.copy(conditionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionStates(ConditionState... conditionStates) {
            conditionStates(Arrays.asList(conditionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionStates(Consumer<ConditionState.Builder>... conditionStates) {
            conditionStates(Stream.of(conditionStates).map(c -> ConditionState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StageConditionState build() {
            return new StageConditionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
