/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionOwner {
    AWS("AWS"),
    THIRD_PARTY("ThirdParty"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionOwner> VALUE_MAP;
    private final String value;

    private ActionOwner(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionOwner fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionOwner> knownValues() {
        EnumSet<ActionOwner> knownValues = EnumSet.allOf(ActionOwner.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionOwner.class, ActionOwner::toString);
    }
}

