/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionRevision;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutActionRevisionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PutActionRevisionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(PutActionRevisionRequest.getter(PutActionRevisionRequest::pipelineName)).setter(PutActionRevisionRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(PutActionRevisionRequest.getter(PutActionRevisionRequest::stageName)).setter(PutActionRevisionRequest.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(PutActionRevisionRequest.getter(PutActionRevisionRequest::actionName)).setter(PutActionRevisionRequest.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<ActionRevision> ACTION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionRevision").getter(PutActionRevisionRequest.getter(PutActionRevisionRequest::actionRevision)).setter(PutActionRevisionRequest.setter(Builder::actionRevision)).constructor(ActionRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, STAGE_NAME_FIELD, ACTION_NAME_FIELD, ACTION_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutActionRevisionRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final String stageName;
    private final String actionName;
    private final ActionRevision actionRevision;

    private PutActionRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.actionRevision = builder.actionRevision;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final ActionRevision actionRevision() {
        return this.actionRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionRevisionRequest)) {
            return false;
        }
        PutActionRevisionRequest other = (PutActionRevisionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.actionRevision(), other.actionRevision());
    }

    public final String toString() {
        return ToString.builder((String)"PutActionRevisionRequest").add("PipelineName", (Object)this.pipelineName()).add("StageName", (Object)this.stageName()).add("ActionName", (Object)this.actionName()).add("ActionRevision", (Object)this.actionRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "actionRevision": {
                return Optional.ofNullable(clazz.cast(this.actionRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("actionRevision", ACTION_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutActionRevisionRequest, T> g) {
        return obj -> g.apply((PutActionRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String actionName;
        private ActionRevision actionRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionRevisionRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.actionRevision(model.actionRevision);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final ActionRevision.Builder getActionRevision() {
            return this.actionRevision != null ? this.actionRevision.toBuilder() : null;
        }

        public final void setActionRevision(ActionRevision.BuilderImpl actionRevision) {
            this.actionRevision = actionRevision != null ? actionRevision.build() : null;
        }

        @Override
        public final Builder actionRevision(ActionRevision actionRevision) {
            this.actionRevision = actionRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutActionRevisionRequest build() {
            return new PutActionRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutActionRevisionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder actionRevision(ActionRevision var1);

        default public Builder actionRevision(Consumer<ActionRevision.Builder> actionRevision) {
            return this.actionRevision((ActionRevision)((ActionRevision.Builder)ActionRevision.builder().applyMutation(actionRevision)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

