/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.CommandListCopier;
import software.amazon.awssdk.services.codepipeline.model.InputArtifact;
import software.amazon.awssdk.services.codepipeline.model.InputArtifactListCopier;
import software.amazon.awssdk.services.codepipeline.model.RuleConfigurationMapCopier;
import software.amazon.awssdk.services.codepipeline.model.RuleTypeId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RuleDeclaration.getter(RuleDeclaration::name)).setter(RuleDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<RuleTypeId> RULE_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ruleTypeId").getter(RuleDeclaration.getter(RuleDeclaration::ruleTypeId)).setter(RuleDeclaration.setter(Builder::ruleTypeId)).constructor(RuleTypeId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleTypeId").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(RuleDeclaration.getter(RuleDeclaration::configuration)).setter(RuleDeclaration.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commands").getter(RuleDeclaration.getter(RuleDeclaration::commands)).setter(RuleDeclaration.setter(Builder::commands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputArtifacts").getter(RuleDeclaration.getter(RuleDeclaration::inputArtifacts)).setter(RuleDeclaration.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(RuleDeclaration.getter(RuleDeclaration::roleArn)).setter(RuleDeclaration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(RuleDeclaration.getter(RuleDeclaration::region)).setter(RuleDeclaration.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMinutes").getter(RuleDeclaration.getter(RuleDeclaration::timeoutInMinutes)).setter(RuleDeclaration.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_TYPE_ID_FIELD, CONFIGURATION_FIELD, COMMANDS_FIELD, INPUT_ARTIFACTS_FIELD, ROLE_ARN_FIELD, REGION_FIELD, TIMEOUT_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleDeclaration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final RuleTypeId ruleTypeId;
    private final Map<String, String> configuration;
    private final List<String> commands;
    private final List<InputArtifact> inputArtifacts;
    private final String roleArn;
    private final String region;
    private final Integer timeoutInMinutes;

    private RuleDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.ruleTypeId = builder.ruleTypeId;
        this.configuration = builder.configuration;
        this.commands = builder.commands;
        this.inputArtifacts = builder.inputArtifacts;
        this.roleArn = builder.roleArn;
        this.region = builder.region;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    public final String name() {
        return this.name;
    }

    public final RuleTypeId ruleTypeId() {
        return this.ruleTypeId;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final boolean hasCommands() {
        return this.commands != null && !(this.commands instanceof SdkAutoConstructList);
    }

    public final List<String> commands() {
        return this.commands;
    }

    public final boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructList);
    }

    public final List<InputArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String region() {
        return this.region;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommands() ? this.commands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleDeclaration)) {
            return false;
        }
        RuleDeclaration other = (RuleDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleTypeId(), other.ruleTypeId()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && this.hasCommands() == other.hasCommands() && Objects.equals(this.commands(), other.commands()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"RuleDeclaration").add("Name", (Object)this.name()).add("RuleTypeId", (Object)this.ruleTypeId()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("Commands", this.hasCommands() ? this.commands() : null).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("RoleArn", (Object)this.roleArn()).add("Region", (Object)this.region()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ruleTypeId": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "commands": {
                return Optional.ofNullable(clazz.cast(this.commands()));
            }
            case "inputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("ruleTypeId", RULE_TYPE_ID_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("commands", COMMANDS_FIELD);
        map.put("inputArtifacts", INPUT_ARTIFACTS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("region", REGION_FIELD);
        map.put("timeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleDeclaration, T> g) {
        return obj -> g.apply((RuleDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private RuleTypeId ruleTypeId;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private List<String> commands = DefaultSdkAutoConstructList.getInstance();
        private List<InputArtifact> inputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private String region;
        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleDeclaration model) {
            this.name(model.name);
            this.ruleTypeId(model.ruleTypeId);
            this.configuration(model.configuration);
            this.commands(model.commands);
            this.inputArtifacts(model.inputArtifacts);
            this.roleArn(model.roleArn);
            this.region(model.region);
            this.timeoutInMinutes(model.timeoutInMinutes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleTypeId.Builder getRuleTypeId() {
            return this.ruleTypeId != null ? this.ruleTypeId.toBuilder() : null;
        }

        public final void setRuleTypeId(RuleTypeId.BuilderImpl ruleTypeId) {
            this.ruleTypeId = ruleTypeId != null ? ruleTypeId.build() : null;
        }

        @Override
        public final Builder ruleTypeId(RuleTypeId ruleTypeId) {
            this.ruleTypeId = ruleTypeId;
            return this;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = RuleConfigurationMapCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = RuleConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final Collection<String> getCommands() {
            if (this.commands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commands;
        }

        public final void setCommands(Collection<String> commands) {
            this.commands = CommandListCopier.copy(commands);
        }

        @Override
        public final Builder commands(Collection<String> commands) {
            this.commands = CommandListCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(String ... commands) {
            this.commands(Arrays.asList(commands));
            return this;
        }

        public final List<InputArtifact.Builder> getInputArtifacts() {
            List<InputArtifact.Builder> result = InputArtifactListCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Collection<InputArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Collection<InputArtifact> inputArtifacts) {
            this.inputArtifacts = InputArtifactListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(InputArtifact ... inputArtifacts) {
            this.inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<InputArtifact.Builder> ... inputArtifacts) {
            this.inputArtifacts(Stream.of(inputArtifacts).map(c -> (InputArtifact)((InputArtifact.Builder)InputArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public RuleDeclaration build() {
            return new RuleDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleDeclaration> {
        public Builder name(String var1);

        public Builder ruleTypeId(RuleTypeId var1);

        default public Builder ruleTypeId(Consumer<RuleTypeId.Builder> ruleTypeId) {
            return this.ruleTypeId((RuleTypeId)((RuleTypeId.Builder)RuleTypeId.builder().applyMutation(ruleTypeId)).build());
        }

        public Builder configuration(Map<String, String> var1);

        public Builder commands(Collection<String> var1);

        public Builder commands(String ... var1);

        public Builder inputArtifacts(Collection<InputArtifact> var1);

        public Builder inputArtifacts(InputArtifact ... var1);

        public Builder inputArtifacts(Consumer<InputArtifact.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder region(String var1);

        public Builder timeoutInMinutes(Integer var1);
    }
}

