/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ListOfToxicContentCopier;
import software.amazon.awssdk.services.comprehend.model.ToxicContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToxicLabels
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToxicLabels> {
    private static final SdkField<List<ToxicContent>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ToxicLabels.getter(ToxicLabels::labels)).setter(ToxicLabels.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToxicContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> TOXICITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Toxicity").getter(ToxicLabels.getter(ToxicLabels::toxicity)).setter(ToxicLabels.setter(Builder::toxicity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Toxicity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELS_FIELD, TOXICITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ToxicContent> labels;
    private final Float toxicity;

    private ToxicLabels(BuilderImpl builder) {
        this.labels = builder.labels;
        this.toxicity = builder.toxicity;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<ToxicContent> labels() {
        return this.labels;
    }

    public final Float toxicity() {
        return this.toxicity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toxicity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicLabels)) {
            return false;
        }
        ToxicLabels other = (ToxicLabels)obj;
        return this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.toxicity(), other.toxicity());
    }

    public final String toString() {
        return ToString.builder((String)"ToxicLabels").add("Labels", this.hasLabels() ? this.labels() : null).add("Toxicity", (Object)this.toxicity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "Toxicity": {
                return Optional.ofNullable(clazz.cast(this.toxicity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ToxicLabels, T> g) {
        return obj -> g.apply((ToxicLabels)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ToxicContent> labels = DefaultSdkAutoConstructList.getInstance();
        private Float toxicity;

        private BuilderImpl() {
        }

        private BuilderImpl(ToxicLabels model) {
            this.labels(model.labels);
            this.toxicity(model.toxicity);
        }

        public final List<ToxicContent.Builder> getLabels() {
            List<ToxicContent.Builder> result = ListOfToxicContentCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<ToxicContent.BuilderImpl> labels) {
            this.labels = ListOfToxicContentCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<ToxicContent> labels) {
            this.labels = ListOfToxicContentCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(ToxicContent ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<ToxicContent.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (ToxicContent)((ToxicContent.Builder)ToxicContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getToxicity() {
            return this.toxicity;
        }

        public final void setToxicity(Float toxicity) {
            this.toxicity = toxicity;
        }

        @Override
        public final Builder toxicity(Float toxicity) {
            this.toxicity = toxicity;
            return this;
        }

        public ToxicLabels build() {
            return new ToxicLabels(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToxicLabels> {
        public Builder labels(Collection<ToxicContent> var1);

        public Builder labels(ToxicContent ... var1);

        public Builder labels(Consumer<ToxicContent.Builder> ... var1);

        public Builder toxicity(Float var1);
    }
}

