/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EntityType {
    MEDICATION("MEDICATION"),
    MEDICAL_CONDITION("MEDICAL_CONDITION"),
    PROTECTED_HEALTH_INFORMATION("PROTECTED_HEALTH_INFORMATION"),
    TEST_TREATMENT_PROCEDURE("TEST_TREATMENT_PROCEDURE"),
    ANATOMY("ANATOMY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EntityType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityType> knownValues() {
        return Stream.of(EntityType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

