/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICD10CMAttributeType {
    ACUITY("ACUITY"),
    DIRECTION("DIRECTION"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    QUALITY("QUALITY"),
    QUANTITY("QUANTITY"),
    TIME_TO_DX_NAME("TIME_TO_DX_NAME"),
    TIME_EXPRESSION("TIME_EXPRESSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICD10CMAttributeType> VALUE_MAP;
    private final String value;

    private ICD10CMAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMAttributeType> knownValues() {
        EnumSet<ICD10CMAttributeType> knownValues = EnumSet.allOf(ICD10CMAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICD10CMAttributeType.class, ICD10CMAttributeType::toString);
    }
}

