/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportableECSServiceField {
    ACCOUNT_ID("AccountId"),
    SERVICE_ARN("ServiceArn"),
    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),
    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),
    LAUNCH_TYPE("LaunchType"),
    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),
    CURRENT_SERVICE_CONFIGURATION_MEMORY("CurrentServiceConfigurationMemory"),
    CURRENT_SERVICE_CONFIGURATION_CPU("CurrentServiceConfigurationCpu"),
    CURRENT_SERVICE_CONFIGURATION_TASK_DEFINITION_ARN("CurrentServiceConfigurationTaskDefinitionArn"),
    CURRENT_SERVICE_CONFIGURATION_AUTO_SCALING_CONFIGURATION("CurrentServiceConfigurationAutoScalingConfiguration"),
    CURRENT_SERVICE_CONTAINER_CONFIGURATIONS("CurrentServiceContainerConfigurations"),
    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),
    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),
    FINDING("Finding"),
    FINDING_REASON_CODES("FindingReasonCodes"),
    RECOMMENDATION_OPTIONS_MEMORY("RecommendationOptionsMemory"),
    RECOMMENDATION_OPTIONS_CPU("RecommendationOptionsCpu"),
    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),
    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),
    RECOMMENDATION_OPTIONS_CONTAINER_RECOMMENDATIONS("RecommendationOptionsContainerRecommendations"),
    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),
    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableECSServiceField> VALUE_MAP;
    private final String value;

    private ExportableECSServiceField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportableECSServiceField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportableECSServiceField> knownValues() {
        EnumSet<ExportableECSServiceField> knownValues = EnumSet.allOf(ExportableECSServiceField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportableECSServiceField.class, ExportableECSServiceField::toString);
    }
}

