/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation;

public class GetLambdaFunctionRecommendationsPublisher
implements SdkPublisher<GetLambdaFunctionRecommendationsResponse> {
    private final ComputeOptimizerAsyncClient client;
    private final GetLambdaFunctionRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetLambdaFunctionRecommendationsPublisher(ComputeOptimizerAsyncClient client, GetLambdaFunctionRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLambdaFunctionRecommendationsPublisher(ComputeOptimizerAsyncClient client, GetLambdaFunctionRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetLambdaFunctionRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetLambdaFunctionRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LambdaFunctionRecommendation> lambdaFunctionRecommendations() {
        Function<GetLambdaFunctionRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lambdaFunctionRecommendations() != null) {
                return response.lambdaFunctionRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetLambdaFunctionRecommendationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetLambdaFunctionRecommendationsResponseFetcher
    implements AsyncPageFetcher<GetLambdaFunctionRecommendationsResponse> {
        private GetLambdaFunctionRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(GetLambdaFunctionRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetLambdaFunctionRecommendationsResponse> nextPage(GetLambdaFunctionRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return GetLambdaFunctionRecommendationsPublisher.this.client.getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsPublisher.this.firstRequest);
            }
            return GetLambdaFunctionRecommendationsPublisher.this.client.getLambdaFunctionRecommendations((GetLambdaFunctionRecommendationsRequest)((Object)GetLambdaFunctionRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

