/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MigrationEffort {
    VERY_LOW("VeryLow"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MigrationEffort> VALUE_MAP;
    private final String value;

    private MigrationEffort(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationEffort fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationEffort> knownValues() {
        EnumSet<MigrationEffort> knownValues = EnumSet.allOf(MigrationEffort.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MigrationEffort.class, MigrationEffort::toString);
    }
}

