/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExternalMetricStatusCode {
    NO_EXTERNAL_METRIC_SET("NO_EXTERNAL_METRIC_SET"),
    INTEGRATION_SUCCESS("INTEGRATION_SUCCESS"),
    DATADOG_INTEGRATION_ERROR("DATADOG_INTEGRATION_ERROR"),
    DYNATRACE_INTEGRATION_ERROR("DYNATRACE_INTEGRATION_ERROR"),
    NEWRELIC_INTEGRATION_ERROR("NEWRELIC_INTEGRATION_ERROR"),
    INSTANA_INTEGRATION_ERROR("INSTANA_INTEGRATION_ERROR"),
    INSUFFICIENT_DATADOG_METRICS("INSUFFICIENT_DATADOG_METRICS"),
    INSUFFICIENT_DYNATRACE_METRICS("INSUFFICIENT_DYNATRACE_METRICS"),
    INSUFFICIENT_NEWRELIC_METRICS("INSUFFICIENT_NEWRELIC_METRICS"),
    INSUFFICIENT_INSTANA_METRICS("INSUFFICIENT_INSTANA_METRICS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExternalMetricStatusCode> VALUE_MAP;
    private final String value;

    private ExternalMetricStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExternalMetricStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExternalMetricStatusCode> knownValues() {
        EnumSet<ExternalMetricStatusCode> knownValues = EnumSet.allOf(ExternalMetricStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExternalMetricStatusCode.class, ExternalMetricStatusCode::toString);
    }
}

