/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationErrorsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.RDSDBRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRdsDatabaseRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetRdsDatabaseRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetRdsDatabaseRecommendationsResponse.getter(GetRdsDatabaseRecommendationsResponse::nextToken)).setter(GetRdsDatabaseRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RDSDBRecommendation>> RDS_DB_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rdsDBRecommendations").getter(GetRdsDatabaseRecommendationsResponse.getter(GetRdsDatabaseRecommendationsResponse::rdsDBRecommendations)).setter(GetRdsDatabaseRecommendationsResponse.setter(Builder::rdsDBRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDBRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RDSDBRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetRdsDatabaseRecommendationsResponse.getter(GetRdsDatabaseRecommendationsResponse::errors)).setter(GetRdsDatabaseRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RDS_DB_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private final String nextToken;
    private final List<RDSDBRecommendation> rdsDBRecommendations;
    private final List<GetRecommendationError> errors;

    private GetRdsDatabaseRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.rdsDBRecommendations = builder.rdsDBRecommendations;
        this.errors = builder.errors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRdsDBRecommendations() {
        return this.rdsDBRecommendations != null && !(this.rdsDBRecommendations instanceof SdkAutoConstructList);
    }

    public final List<RDSDBRecommendation> rdsDBRecommendations() {
        return this.rdsDBRecommendations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<GetRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRdsDBRecommendations() ? this.rdsDBRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRdsDatabaseRecommendationsResponse)) {
            return false;
        }
        GetRdsDatabaseRecommendationsResponse other = (GetRdsDatabaseRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRdsDBRecommendations() == other.hasRdsDBRecommendations() && Objects.equals(this.rdsDBRecommendations(), other.rdsDBRecommendations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"GetRdsDatabaseRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("RdsDBRecommendations", this.hasRdsDBRecommendations() ? this.rdsDBRecommendations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "rdsDBRecommendations": {
                return Optional.ofNullable(clazz.cast(this.rdsDBRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRdsDatabaseRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRdsDatabaseRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RDSDBRecommendation> rdsDBRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRdsDatabaseRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.rdsDBRecommendations(model.rdsDBRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RDSDBRecommendation.Builder> getRdsDBRecommendations() {
            List<RDSDBRecommendation.Builder> result = RDSDBRecommendationsCopier.copyToBuilder(this.rdsDBRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRdsDBRecommendations(Collection<RDSDBRecommendation.BuilderImpl> rdsDBRecommendations) {
            this.rdsDBRecommendations = RDSDBRecommendationsCopier.copyFromBuilder(rdsDBRecommendations);
        }

        @Override
        public final Builder rdsDBRecommendations(Collection<RDSDBRecommendation> rdsDBRecommendations) {
            this.rdsDBRecommendations = RDSDBRecommendationsCopier.copy(rdsDBRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDBRecommendations(RDSDBRecommendation ... rdsDBRecommendations) {
            this.rdsDBRecommendations(Arrays.asList(rdsDBRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDBRecommendations(Consumer<RDSDBRecommendation.Builder> ... rdsDBRecommendations) {
            this.rdsDBRecommendations(Stream.of(rdsDBRecommendations).map(c -> (RDSDBRecommendation)((RDSDBRecommendation.Builder)RDSDBRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetRecommendationError.Builder> getErrors() {
            List<GetRecommendationError.Builder> result = GetRecommendationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetRecommendationError)((GetRecommendationError.Builder)GetRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRdsDatabaseRecommendationsResponse build() {
            return new GetRdsDatabaseRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRdsDatabaseRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder rdsDBRecommendations(Collection<RDSDBRecommendation> var1);

        public Builder rdsDBRecommendations(RDSDBRecommendation ... var1);

        public Builder rdsDBRecommendations(Consumer<RDSDBRecommendation.Builder> ... var1);

        public Builder errors(Collection<GetRecommendationError> var1);

        public Builder errors(GetRecommendationError ... var1);

        public Builder errors(Consumer<GetRecommendationError.Builder> ... var1);
    }
}

