/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient;
import software.amazon.awssdk.services.computeoptimizer.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob;

public class DescribeRecommendationExportJobsPublisher
implements SdkPublisher<DescribeRecommendationExportJobsResponse> {
    private final ComputeOptimizerAsyncClient client;
    private final DescribeRecommendationExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRecommendationExportJobsPublisher(ComputeOptimizerAsyncClient client, DescribeRecommendationExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRecommendationExportJobsPublisher(ComputeOptimizerAsyncClient client, DescribeRecommendationExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRecommendationExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRecommendationExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendationExportJob> recommendationExportJobs() {
        Function<DescribeRecommendationExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationExportJobs() != null) {
                return response.recommendationExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRecommendationExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRecommendationExportJobsResponseFetcher
    implements AsyncPageFetcher<DescribeRecommendationExportJobsResponse> {
        private DescribeRecommendationExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecommendationExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRecommendationExportJobsResponse> nextPage(DescribeRecommendationExportJobsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecommendationExportJobsPublisher.this.client.describeRecommendationExportJobs(DescribeRecommendationExportJobsPublisher.this.firstRequest);
            }
            return DescribeRecommendationExportJobsPublisher.this.client.describeRecommendationExportJobs((DescribeRecommendationExportJobsRequest)((Object)DescribeRecommendationExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

