/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogAsyncClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.CommonControlSummary;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsResponse;

public class ListCommonControlsPublisher
implements SdkPublisher<ListCommonControlsResponse> {
    private final ControlCatalogAsyncClient client;
    private final ListCommonControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommonControlsPublisher(ControlCatalogAsyncClient client, ListCommonControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommonControlsPublisher(ControlCatalogAsyncClient client, ListCommonControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommonControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommonControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CommonControlSummary> commonControls() {
        Function<ListCommonControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commonControls() != null) {
                return response.commonControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommonControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommonControlsResponseFetcher
    implements AsyncPageFetcher<ListCommonControlsResponse> {
        private ListCommonControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommonControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommonControlsResponse> nextPage(ListCommonControlsResponse previousPage) {
            if (previousPage == null) {
                return ListCommonControlsPublisher.this.client.listCommonControls(ListCommonControlsPublisher.this.firstRequest);
            }
            return ListCommonControlsPublisher.this.client.listCommonControls((ListCommonControlsRequest)((Object)ListCommonControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

