/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlIdentifiersCopier;
import software.amazon.awssdk.services.controltower.model.ControlOperationStatus;
import software.amazon.awssdk.services.controltower.model.ControlOperationStatusesCopier;
import software.amazon.awssdk.services.controltower.model.ControlOperationType;
import software.amazon.awssdk.services.controltower.model.ControlOperationTypesCopier;
import software.amazon.awssdk.services.controltower.model.EnabledControlIdentifiersCopier;
import software.amazon.awssdk.services.controltower.model.TargetIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlOperationFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlOperationFilter> {
    private static final SdkField<List<String>> CONTROL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlIdentifiers").getter(ControlOperationFilter.getter(ControlOperationFilter::controlIdentifiers)).setter(ControlOperationFilter.setter(Builder::controlIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTROL_OPERATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlOperationTypes").getter(ControlOperationFilter.getter(ControlOperationFilter::controlOperationTypesAsStrings)).setter(ControlOperationFilter.setter(Builder::controlOperationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlOperationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ENABLED_CONTROL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("enabledControlIdentifiers").getter(ControlOperationFilter.getter(ControlOperationFilter::enabledControlIdentifiers)).setter(ControlOperationFilter.setter(Builder::enabledControlIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledControlIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statuses").getter(ControlOperationFilter.getter(ControlOperationFilter::statusesAsStrings)).setter(ControlOperationFilter.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetIdentifiers").getter(ControlOperationFilter.getter(ControlOperationFilter::targetIdentifiers)).setter(ControlOperationFilter.setter(Builder::targetIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_IDENTIFIERS_FIELD, CONTROL_OPERATION_TYPES_FIELD, ENABLED_CONTROL_IDENTIFIERS_FIELD, STATUSES_FIELD, TARGET_IDENTIFIERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> controlIdentifiers;
    private final List<String> controlOperationTypes;
    private final List<String> enabledControlIdentifiers;
    private final List<String> statuses;
    private final List<String> targetIdentifiers;

    private ControlOperationFilter(BuilderImpl builder) {
        this.controlIdentifiers = builder.controlIdentifiers;
        this.controlOperationTypes = builder.controlOperationTypes;
        this.enabledControlIdentifiers = builder.enabledControlIdentifiers;
        this.statuses = builder.statuses;
        this.targetIdentifiers = builder.targetIdentifiers;
    }

    public final boolean hasControlIdentifiers() {
        return this.controlIdentifiers != null && !(this.controlIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> controlIdentifiers() {
        return this.controlIdentifiers;
    }

    public final List<ControlOperationType> controlOperationTypes() {
        return ControlOperationTypesCopier.copyStringToEnum(this.controlOperationTypes);
    }

    public final boolean hasControlOperationTypes() {
        return this.controlOperationTypes != null && !(this.controlOperationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> controlOperationTypesAsStrings() {
        return this.controlOperationTypes;
    }

    public final boolean hasEnabledControlIdentifiers() {
        return this.enabledControlIdentifiers != null && !(this.enabledControlIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> enabledControlIdentifiers() {
        return this.enabledControlIdentifiers;
    }

    public final List<ControlOperationStatus> statuses() {
        return ControlOperationStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructList);
    }

    public final List<String> statusesAsStrings() {
        return this.statuses;
    }

    public final boolean hasTargetIdentifiers() {
        return this.targetIdentifiers != null && !(this.targetIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> targetIdentifiers() {
        return this.targetIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlIdentifiers() ? this.controlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlOperationTypes() ? this.controlOperationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledControlIdentifiers() ? this.enabledControlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIdentifiers() ? this.targetIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlOperationFilter)) {
            return false;
        }
        ControlOperationFilter other = (ControlOperationFilter)obj;
        return this.hasControlIdentifiers() == other.hasControlIdentifiers() && Objects.equals(this.controlIdentifiers(), other.controlIdentifiers()) && this.hasControlOperationTypes() == other.hasControlOperationTypes() && Objects.equals(this.controlOperationTypesAsStrings(), other.controlOperationTypesAsStrings()) && this.hasEnabledControlIdentifiers() == other.hasEnabledControlIdentifiers() && Objects.equals(this.enabledControlIdentifiers(), other.enabledControlIdentifiers()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings()) && this.hasTargetIdentifiers() == other.hasTargetIdentifiers() && Objects.equals(this.targetIdentifiers(), other.targetIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ControlOperationFilter").add("ControlIdentifiers", this.hasControlIdentifiers() ? this.controlIdentifiers() : null).add("ControlOperationTypes", this.hasControlOperationTypes() ? this.controlOperationTypesAsStrings() : null).add("EnabledControlIdentifiers", this.hasEnabledControlIdentifiers() ? this.enabledControlIdentifiers() : null).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).add("TargetIdentifiers", this.hasTargetIdentifiers() ? this.targetIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.controlIdentifiers()));
            }
            case "controlOperationTypes": {
                return Optional.ofNullable(clazz.cast(this.controlOperationTypesAsStrings()));
            }
            case "enabledControlIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.enabledControlIdentifiers()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
            case "targetIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlOperationFilter, T> g) {
        return obj -> g.apply((ControlOperationFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> controlIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> controlOperationTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> enabledControlIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlOperationFilter model) {
            this.controlIdentifiers(model.controlIdentifiers);
            this.controlOperationTypesWithStrings(model.controlOperationTypes);
            this.enabledControlIdentifiers(model.enabledControlIdentifiers);
            this.statusesWithStrings(model.statuses);
            this.targetIdentifiers(model.targetIdentifiers);
        }

        public final Collection<String> getControlIdentifiers() {
            if (this.controlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlIdentifiers;
        }

        public final void setControlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
        }

        @Override
        public final Builder controlIdentifiers(Collection<String> controlIdentifiers) {
            this.controlIdentifiers = ControlIdentifiersCopier.copy(controlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlIdentifiers(String ... controlIdentifiers) {
            this.controlIdentifiers(Arrays.asList(controlIdentifiers));
            return this;
        }

        public final Collection<String> getControlOperationTypes() {
            if (this.controlOperationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlOperationTypes;
        }

        public final void setControlOperationTypes(Collection<String> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copy(controlOperationTypes);
        }

        @Override
        public final Builder controlOperationTypesWithStrings(Collection<String> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copy(controlOperationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperationTypesWithStrings(String ... controlOperationTypes) {
            this.controlOperationTypesWithStrings(Arrays.asList(controlOperationTypes));
            return this;
        }

        @Override
        public final Builder controlOperationTypes(Collection<ControlOperationType> controlOperationTypes) {
            this.controlOperationTypes = ControlOperationTypesCopier.copyEnumToString(controlOperationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperationTypes(ControlOperationType ... controlOperationTypes) {
            this.controlOperationTypes(Arrays.asList(controlOperationTypes));
            return this;
        }

        public final Collection<String> getEnabledControlIdentifiers() {
            if (this.enabledControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledControlIdentifiers;
        }

        public final void setEnabledControlIdentifiers(Collection<String> enabledControlIdentifiers) {
            this.enabledControlIdentifiers = EnabledControlIdentifiersCopier.copy(enabledControlIdentifiers);
        }

        @Override
        public final Builder enabledControlIdentifiers(Collection<String> enabledControlIdentifiers) {
            this.enabledControlIdentifiers = EnabledControlIdentifiersCopier.copy(enabledControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledControlIdentifiers(String ... enabledControlIdentifiers) {
            this.enabledControlIdentifiers(Arrays.asList(enabledControlIdentifiers));
            return this;
        }

        public final Collection<String> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ControlOperationStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ControlOperationStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String ... statuses) {
            this.statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ControlOperationStatus> statuses) {
            this.statuses = ControlOperationStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ControlOperationStatus ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        public final Collection<String> getTargetIdentifiers() {
            if (this.targetIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetIdentifiers;
        }

        public final void setTargetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = TargetIdentifiersCopier.copy(targetIdentifiers);
        }

        @Override
        public final Builder targetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = TargetIdentifiersCopier.copy(targetIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdentifiers(String ... targetIdentifiers) {
            this.targetIdentifiers(Arrays.asList(targetIdentifiers));
            return this;
        }

        public ControlOperationFilter build() {
            return new ControlOperationFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlOperationFilter> {
        public Builder controlIdentifiers(Collection<String> var1);

        public Builder controlIdentifiers(String ... var1);

        public Builder controlOperationTypesWithStrings(Collection<String> var1);

        public Builder controlOperationTypesWithStrings(String ... var1);

        public Builder controlOperationTypes(Collection<ControlOperationType> var1);

        public Builder controlOperationTypes(ControlOperationType ... var1);

        public Builder enabledControlIdentifiers(Collection<String> var1);

        public Builder enabledControlIdentifiers(String ... var1);

        public Builder statusesWithStrings(Collection<String> var1);

        public Builder statusesWithStrings(String ... var1);

        public Builder statuses(Collection<ControlOperationStatus> var1);

        public Builder statuses(ControlOperationStatus ... var1);

        public Builder targetIdentifiers(Collection<String> var1);

        public Builder targetIdentifiers(String ... var1);
    }
}

