/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlOperationType {
    ENABLE_CONTROL("ENABLE_CONTROL"),
    DISABLE_CONTROL("DISABLE_CONTROL"),
    UPDATE_ENABLED_CONTROL("UPDATE_ENABLED_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlOperationType> VALUE_MAP;
    private final String value;

    private ControlOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlOperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlOperationType> knownValues() {
        EnumSet<ControlOperationType> knownValues = EnumSet.allOf(ControlOperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlOperationType.class, ControlOperationType::toString);
    }
}

