/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BaselineOperationType {
    ENABLE_BASELINE("ENABLE_BASELINE"),
    DISABLE_BASELINE("DISABLE_BASELINE"),
    UPDATE_ENABLED_BASELINE("UPDATE_ENABLED_BASELINE"),
    RESET_ENABLED_BASELINE("RESET_ENABLED_BASELINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BaselineOperationType> VALUE_MAP;
    private final String value;

    private BaselineOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BaselineOperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BaselineOperationType> knownValues() {
        EnumSet<BaselineOperationType> knownValues = EnumSet.allOf(BaselineOperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BaselineOperationType.class, BaselineOperationType::toString);
    }
}

