/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KafkaSaslMechanism {
    SCRAM_SHA_512("scram-sha-512"),
    PLAIN("plain"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KafkaSaslMechanism> VALUE_MAP;
    private final String value;

    private KafkaSaslMechanism(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KafkaSaslMechanism fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KafkaSaslMechanism> knownValues() {
        EnumSet<KafkaSaslMechanism> knownValues = EnumSet.allOf(KafkaSaslMechanism.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KafkaSaslMechanism.class, KafkaSaslMechanism::toString);
    }
}

