/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SslSecurityProtocolValue {
    PLAINTEXT("plaintext"),
    SSL_ENCRYPTION("ssl-encryption"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SslSecurityProtocolValue> VALUE_MAP;
    private final String value;

    private SslSecurityProtocolValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SslSecurityProtocolValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SslSecurityProtocolValue> knownValues() {
        EnumSet<SslSecurityProtocolValue> knownValues = EnumSet.allOf(SslSecurityProtocolValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SslSecurityProtocolValue.class, SslSecurityProtocolValue::toString);
    }
}

