/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMetadataModelExportToTargetRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartMetadataModelExportToTargetRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(StartMetadataModelExportToTargetRequest.getter(StartMetadataModelExportToTargetRequest::migrationProjectIdentifier)).setter(StartMetadataModelExportToTargetRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(StartMetadataModelExportToTargetRequest.getter(StartMetadataModelExportToTargetRequest::selectionRules)).setter(StartMetadataModelExportToTargetRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_EXTENSION_PACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OverwriteExtensionPack").getter(StartMetadataModelExportToTargetRequest.getter(StartMetadataModelExportToTargetRequest::overwriteExtensionPack)).setter(StartMetadataModelExportToTargetRequest.setter(Builder::overwriteExtensionPack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteExtensionPack").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, OVERWRITE_EXTENSION_PACK_FIELD));
    private final String migrationProjectIdentifier;
    private final String selectionRules;
    private final Boolean overwriteExtensionPack;

    private StartMetadataModelExportToTargetRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.overwriteExtensionPack = builder.overwriteExtensionPack;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    public final Boolean overwriteExtensionPack() {
        return this.overwriteExtensionPack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteExtensionPack());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelExportToTargetRequest)) {
            return false;
        }
        StartMetadataModelExportToTargetRequest other = (StartMetadataModelExportToTargetRequest)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.selectionRules(), other.selectionRules()) && Objects.equals(this.overwriteExtensionPack(), other.overwriteExtensionPack());
    }

    public final String toString() {
        return ToString.builder((String)"StartMetadataModelExportToTargetRequest").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("SelectionRules", (Object)this.selectionRules()).add("OverwriteExtensionPack", (Object)this.overwriteExtensionPack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
            case "OverwriteExtensionPack": {
                return Optional.ofNullable(clazz.cast(this.overwriteExtensionPack()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelExportToTargetRequest, T> g) {
        return obj -> g.apply((StartMetadataModelExportToTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String selectionRules;
        private Boolean overwriteExtensionPack;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelExportToTargetRequest model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.selectionRules(model.selectionRules);
            this.overwriteExtensionPack(model.overwriteExtensionPack);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final Boolean getOverwriteExtensionPack() {
            return this.overwriteExtensionPack;
        }

        public final void setOverwriteExtensionPack(Boolean overwriteExtensionPack) {
            this.overwriteExtensionPack = overwriteExtensionPack;
        }

        @Override
        public final Builder overwriteExtensionPack(Boolean overwriteExtensionPack) {
            this.overwriteExtensionPack = overwriteExtensionPack;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataModelExportToTargetRequest build() {
            return new StartMetadataModelExportToTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMetadataModelExportToTargetRequest> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder selectionRules(String var1);

        public Builder overwriteExtensionPack(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

