/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dax.DaxAsyncClient;
import software.amazon.awssdk.services.dax.DaxAsyncClientBuilder;
import software.amazon.awssdk.services.dax.DaxServiceClientConfiguration;
import software.amazon.awssdk.services.dax.DefaultDaxAsyncClient;
import software.amazon.awssdk.services.dax.DefaultDaxBaseClientBuilder;
import software.amazon.awssdk.services.dax.endpoints.DaxEndpointProvider;

@SdkInternalApi
final class DefaultDaxAsyncClientBuilder
extends DefaultDaxBaseClientBuilder<DaxAsyncClientBuilder, DaxAsyncClient>
implements DaxAsyncClientBuilder {
    DefaultDaxAsyncClientBuilder() {
    }

    @Override
    public DefaultDaxAsyncClientBuilder endpointProvider(DaxEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DaxAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDaxAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DaxServiceClientConfiguration serviceClientConfiguration = DaxServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDaxAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

