/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse;

public class ListTestGridSessionsIterable
implements SdkIterable<ListTestGridSessionsResponse> {
    private final DeviceFarmClient client;
    private final ListTestGridSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestGridSessionsIterable(DeviceFarmClient client, ListTestGridSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestGridSessionsResponseFetcher();
    }

    public Iterator<ListTestGridSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestGridSessionsResponseFetcher
    implements SyncPageFetcher<ListTestGridSessionsResponse> {
        private ListTestGridSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestGridSessionsResponse nextPage(ListTestGridSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridSessionsIterable.this.client.listTestGridSessions(ListTestGridSessionsIterable.this.firstRequest);
            }
            return ListTestGridSessionsIterable.this.client.listTestGridSessions((ListTestGridSessionsRequest)((Object)ListTestGridSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

