/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDataSummary;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimension;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsDimensionsCopier;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricsStat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchMetricsDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchMetricsDetail> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::metricName)).setter(CloudWatchMetricsDetail.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::namespace)).setter(CloudWatchMetricsDetail.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<List<CloudWatchMetricsDimension>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Dimensions").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::dimensions)).setter(CloudWatchMetricsDetail.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchMetricsDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stat").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::statAsString)).setter(CloudWatchMetricsDetail.setter(Builder::stat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::unit)).setter(CloudWatchMetricsDetail.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::period)).setter(CloudWatchMetricsDetail.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<CloudWatchMetricsDataSummary> METRIC_DATA_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricDataSummary").getter(CloudWatchMetricsDetail.getter(CloudWatchMetricsDetail::metricDataSummary)).setter(CloudWatchMetricsDetail.setter(Builder::metricDataSummary)).constructor(CloudWatchMetricsDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAMESPACE_FIELD, DIMENSIONS_FIELD, STAT_FIELD, UNIT_FIELD, PERIOD_FIELD, METRIC_DATA_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String namespace;
    private final List<CloudWatchMetricsDimension> dimensions;
    private final String stat;
    private final String unit;
    private final Integer period;
    private final CloudWatchMetricsDataSummary metricDataSummary;

    private CloudWatchMetricsDetail(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.dimensions = builder.dimensions;
        this.stat = builder.stat;
        this.unit = builder.unit;
        this.period = builder.period;
        this.metricDataSummary = builder.metricDataSummary;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final boolean hasDimensions() {
        return this.dimensions != null && !(this.dimensions instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchMetricsDimension> dimensions() {
        return this.dimensions;
    }

    public final CloudWatchMetricsStat stat() {
        return CloudWatchMetricsStat.fromValue(this.stat);
    }

    public final String statAsString() {
        return this.stat;
    }

    public final String unit() {
        return this.unit;
    }

    public final Integer period() {
        return this.period;
    }

    public final CloudWatchMetricsDataSummary metricDataSummary() {
        return this.metricDataSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensions() ? this.dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDataSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMetricsDetail)) {
            return false;
        }
        CloudWatchMetricsDetail other = (CloudWatchMetricsDetail)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && this.hasDimensions() == other.hasDimensions() && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.statAsString(), other.statAsString()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.metricDataSummary(), other.metricDataSummary());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchMetricsDetail").add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Dimensions", this.hasDimensions() ? this.dimensions() : null).add("Stat", (Object)this.statAsString()).add("Unit", (Object)this.unit()).add("Period", (Object)this.period()).add("MetricDataSummary", (Object)this.metricDataSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Stat": {
                return Optional.ofNullable(clazz.cast(this.statAsString()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "MetricDataSummary": {
                return Optional.ofNullable(clazz.cast(this.metricDataSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMetricsDetail, T> g) {
        return obj -> g.apply((CloudWatchMetricsDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String namespace;
        private List<CloudWatchMetricsDimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private String stat;
        private String unit;
        private Integer period;
        private CloudWatchMetricsDataSummary metricDataSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMetricsDetail model) {
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.dimensions(model.dimensions);
            this.stat(model.stat);
            this.unit(model.unit);
            this.period(model.period);
            this.metricDataSummary(model.metricDataSummary);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<CloudWatchMetricsDimension.Builder> getDimensions() {
            List<CloudWatchMetricsDimension.Builder> result = CloudWatchMetricsDimensionsCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<CloudWatchMetricsDimension.BuilderImpl> dimensions) {
            this.dimensions = CloudWatchMetricsDimensionsCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<CloudWatchMetricsDimension> dimensions) {
            this.dimensions = CloudWatchMetricsDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(CloudWatchMetricsDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<CloudWatchMetricsDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (CloudWatchMetricsDimension)((CloudWatchMetricsDimension.Builder)CloudWatchMetricsDimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStat() {
            return this.stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        @Override
        public final Builder stat(CloudWatchMetricsStat stat) {
            this.stat(stat == null ? null : stat.toString());
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final CloudWatchMetricsDataSummary.Builder getMetricDataSummary() {
            return this.metricDataSummary != null ? this.metricDataSummary.toBuilder() : null;
        }

        public final void setMetricDataSummary(CloudWatchMetricsDataSummary.BuilderImpl metricDataSummary) {
            this.metricDataSummary = metricDataSummary != null ? metricDataSummary.build() : null;
        }

        @Override
        public final Builder metricDataSummary(CloudWatchMetricsDataSummary metricDataSummary) {
            this.metricDataSummary = metricDataSummary;
            return this;
        }

        public CloudWatchMetricsDetail build() {
            return new CloudWatchMetricsDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchMetricsDetail> {
        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder dimensions(Collection<CloudWatchMetricsDimension> var1);

        public Builder dimensions(CloudWatchMetricsDimension ... var1);

        public Builder dimensions(Consumer<CloudWatchMetricsDimension.Builder> ... var1);

        public Builder stat(String var1);

        public Builder stat(CloudWatchMetricsStat var1);

        public Builder unit(String var1);

        public Builder period(Integer var1);

        public Builder metricDataSummary(CloudWatchMetricsDataSummary var1);

        default public Builder metricDataSummary(Consumer<CloudWatchMetricsDataSummary.Builder> metricDataSummary) {
            return this.metricDataSummary((CloudWatchMetricsDataSummary)((CloudWatchMetricsDataSummary.Builder)CloudWatchMetricsDataSummary.builder().applyMutation(metricDataSummary)).build());
        }
    }
}

