/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.AccountHealth;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealth;
import software.amazon.awssdk.services.devopsguru.model.TagHealth;

public class DescribeOrganizationResourceCollectionHealthPublisher
implements SdkPublisher<DescribeOrganizationResourceCollectionHealthResponse> {
    private final DevOpsGuruAsyncClient client;
    private final DescribeOrganizationResourceCollectionHealthRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrganizationResourceCollectionHealthPublisher(DevOpsGuruAsyncClient client, DescribeOrganizationResourceCollectionHealthRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrganizationResourceCollectionHealthPublisher(DevOpsGuruAsyncClient client, DescribeOrganizationResourceCollectionHealthRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrganizationResourceCollectionHealthResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrganizationResourceCollectionHealthResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudFormationHealth> cloudFormation() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFormation() != null) {
                return response.cloudFormation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrganizationResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<AccountHealth> account() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.account() != null) {
                return response.account().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrganizationResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ServiceHealth> service() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.service() != null) {
                return response.service().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrganizationResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<TagHealth> tags() {
        Function<DescribeOrganizationResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrganizationResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOrganizationResourceCollectionHealthResponseFetcher
    implements AsyncPageFetcher<DescribeOrganizationResourceCollectionHealthResponse> {
        private DescribeOrganizationResourceCollectionHealthResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationResourceCollectionHealthResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOrganizationResourceCollectionHealthResponse> nextPage(DescribeOrganizationResourceCollectionHealthResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationResourceCollectionHealthPublisher.this.client.describeOrganizationResourceCollectionHealth(DescribeOrganizationResourceCollectionHealthPublisher.this.firstRequest);
            }
            return DescribeOrganizationResourceCollectionHealthPublisher.this.client.describeOrganizationResourceCollectionHealth((DescribeOrganizationResourceCollectionHealthRequest)((Object)DescribeOrganizationResourceCollectionHealthPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

