/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest;
import software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealth;
import software.amazon.awssdk.services.devopsguru.model.TagHealth;

public class DescribeResourceCollectionHealthPublisher
implements SdkPublisher<DescribeResourceCollectionHealthResponse> {
    private final DevOpsGuruAsyncClient client;
    private final DescribeResourceCollectionHealthRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeResourceCollectionHealthPublisher(DevOpsGuruAsyncClient client, DescribeResourceCollectionHealthRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeResourceCollectionHealthPublisher(DevOpsGuruAsyncClient client, DescribeResourceCollectionHealthRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeResourceCollectionHealthResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeResourceCollectionHealthResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudFormationHealth> cloudFormation() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudFormation() != null) {
                return response.cloudFormation().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<ServiceHealth> service() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.service() != null) {
                return response.service().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<TagHealth> tags() {
        Function<DescribeResourceCollectionHealthResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeResourceCollectionHealthResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeResourceCollectionHealthResponseFetcher
    implements AsyncPageFetcher<DescribeResourceCollectionHealthResponse> {
        private DescribeResourceCollectionHealthResponseFetcher() {
        }

        public boolean hasNextPage(DescribeResourceCollectionHealthResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeResourceCollectionHealthResponse> nextPage(DescribeResourceCollectionHealthResponse previousPage) {
            if (previousPage == null) {
                return DescribeResourceCollectionHealthPublisher.this.client.describeResourceCollectionHealth(DescribeResourceCollectionHealthPublisher.this.firstRequest);
            }
            return DescribeResourceCollectionHealthPublisher.this.client.describeResourceCollectionHealth((DescribeResourceCollectionHealthRequest)((Object)DescribeResourceCollectionHealthPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

