/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruBaseClientBuilder;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClientBuilder;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruServiceClientConfiguration;
import software.amazon.awssdk.services.devopsguru.endpoints.DevOpsGuruEndpointProvider;

@SdkInternalApi
final class DefaultDevOpsGuruClientBuilder
extends DefaultDevOpsGuruBaseClientBuilder<DevOpsGuruClientBuilder, DevOpsGuruClient>
implements DevOpsGuruClientBuilder {
    DefaultDevOpsGuruClientBuilder() {
    }

    @Override
    public DefaultDevOpsGuruClientBuilder endpointProvider(DevOpsGuruEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DevOpsGuruClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDevOpsGuruClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DevOpsGuruServiceClientConfiguration serviceClientConfiguration = DevOpsGuruServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDevOpsGuruClient(serviceClientConfiguration, clientConfiguration);
    }
}

