/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest;
import software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesResponse;
import software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier;

public class ListMonitoredResourcesIterable
implements SdkIterable<ListMonitoredResourcesResponse> {
    private final DevOpsGuruClient client;
    private final ListMonitoredResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitoredResourcesIterable(DevOpsGuruClient client, ListMonitoredResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMonitoredResourcesResponseFetcher();
    }

    public Iterator<ListMonitoredResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoredResourceIdentifier> monitoredResourceIdentifiers() {
        Function<ListMonitoredResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoredResourceIdentifiers() != null) {
                return response.monitoredResourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitoredResourcesResponseFetcher
    implements SyncPageFetcher<ListMonitoredResourcesResponse> {
        private ListMonitoredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitoredResourcesResponse nextPage(ListMonitoredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoredResourcesIterable.this.client.listMonitoredResources(ListMonitoredResourcesIterable.this.firstRequest);
            }
            return ListMonitoredResourcesIterable.this.client.listMonitoredResources((ListMonitoredResourcesRequest)((Object)ListMonitoredResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

