/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange;
import software.amazon.awssdk.services.devopsguru.model.AnomalyResource;
import software.amazon.awssdk.services.devopsguru.model.AnomalyResourcesCopier;
import software.amazon.awssdk.services.devopsguru.model.AnomalySeverity;
import software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails;
import software.amazon.awssdk.services.devopsguru.model.AnomalySourceMetadata;
import software.amazon.awssdk.services.devopsguru.model.AnomalyStatus;
import software.amazon.awssdk.services.devopsguru.model.AnomalyTimeRange;
import software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProactiveAnomalySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProactiveAnomalySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::id)).setter(ProactiveAnomalySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::severityAsString)).setter(ProactiveAnomalySummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::statusAsString)).setter(ProactiveAnomalySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::updateTime)).setter(ProactiveAnomalySummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<AnomalyTimeRange> ANOMALY_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyTimeRange").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::anomalyTimeRange)).setter(ProactiveAnomalySummary.setter(Builder::anomalyTimeRange)).constructor(AnomalyTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyTimeRange").build()}).build();
    private static final SdkField<AnomalyReportedTimeRange> ANOMALY_REPORTED_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyReportedTimeRange").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::anomalyReportedTimeRange)).setter(ProactiveAnomalySummary.setter(Builder::anomalyReportedTimeRange)).constructor(AnomalyReportedTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyReportedTimeRange").build()}).build();
    private static final SdkField<PredictionTimeRange> PREDICTION_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictionTimeRange").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::predictionTimeRange)).setter(ProactiveAnomalySummary.setter(Builder::predictionTimeRange)).constructor(PredictionTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionTimeRange").build()}).build();
    private static final SdkField<AnomalySourceDetails> SOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDetails").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::sourceDetails)).setter(ProactiveAnomalySummary.setter(Builder::sourceDetails)).constructor(AnomalySourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetails").build()}).build();
    private static final SdkField<String> ASSOCIATED_INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedInsightId").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::associatedInsightId)).setter(ProactiveAnomalySummary.setter(Builder::associatedInsightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedInsightId").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::resourceCollection)).setter(ProactiveAnomalySummary.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<Double> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Limit").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::limit)).setter(ProactiveAnomalySummary.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<AnomalySourceMetadata> SOURCE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceMetadata").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::sourceMetadata)).setter(ProactiveAnomalySummary.setter(Builder::sourceMetadata)).constructor(AnomalySourceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMetadata").build()}).build();
    private static final SdkField<List<AnomalyResource>> ANOMALY_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyResources").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::anomalyResources)).setter(ProactiveAnomalySummary.setter(Builder::anomalyResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProactiveAnomalySummary.getter(ProactiveAnomalySummary::description)).setter(ProactiveAnomalySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEVERITY_FIELD, STATUS_FIELD, UPDATE_TIME_FIELD, ANOMALY_TIME_RANGE_FIELD, ANOMALY_REPORTED_TIME_RANGE_FIELD, PREDICTION_TIME_RANGE_FIELD, SOURCE_DETAILS_FIELD, ASSOCIATED_INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD, LIMIT_FIELD, SOURCE_METADATA_FIELD, ANOMALY_RESOURCES_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Severity", SEVERITY_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("UpdateTime", UPDATE_TIME_FIELD);
            this.put("AnomalyTimeRange", ANOMALY_TIME_RANGE_FIELD);
            this.put("AnomalyReportedTimeRange", ANOMALY_REPORTED_TIME_RANGE_FIELD);
            this.put("PredictionTimeRange", PREDICTION_TIME_RANGE_FIELD);
            this.put("SourceDetails", SOURCE_DETAILS_FIELD);
            this.put("AssociatedInsightId", ASSOCIATED_INSIGHT_ID_FIELD);
            this.put("ResourceCollection", RESOURCE_COLLECTION_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("SourceMetadata", SOURCE_METADATA_FIELD);
            this.put("AnomalyResources", ANOMALY_RESOURCES_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String severity;
    private final String status;
    private final Instant updateTime;
    private final AnomalyTimeRange anomalyTimeRange;
    private final AnomalyReportedTimeRange anomalyReportedTimeRange;
    private final PredictionTimeRange predictionTimeRange;
    private final AnomalySourceDetails sourceDetails;
    private final String associatedInsightId;
    private final ResourceCollection resourceCollection;
    private final Double limit;
    private final AnomalySourceMetadata sourceMetadata;
    private final List<AnomalyResource> anomalyResources;
    private final String description;

    private ProactiveAnomalySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.severity = builder.severity;
        this.status = builder.status;
        this.updateTime = builder.updateTime;
        this.anomalyTimeRange = builder.anomalyTimeRange;
        this.anomalyReportedTimeRange = builder.anomalyReportedTimeRange;
        this.predictionTimeRange = builder.predictionTimeRange;
        this.sourceDetails = builder.sourceDetails;
        this.associatedInsightId = builder.associatedInsightId;
        this.resourceCollection = builder.resourceCollection;
        this.limit = builder.limit;
        this.sourceMetadata = builder.sourceMetadata;
        this.anomalyResources = builder.anomalyResources;
        this.description = builder.description;
    }

    public final String id() {
        return this.id;
    }

    public final AnomalySeverity severity() {
        return AnomalySeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final AnomalyStatus status() {
        return AnomalyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final AnomalyTimeRange anomalyTimeRange() {
        return this.anomalyTimeRange;
    }

    public final AnomalyReportedTimeRange anomalyReportedTimeRange() {
        return this.anomalyReportedTimeRange;
    }

    public final PredictionTimeRange predictionTimeRange() {
        return this.predictionTimeRange;
    }

    public final AnomalySourceDetails sourceDetails() {
        return this.sourceDetails;
    }

    public final String associatedInsightId() {
        return this.associatedInsightId;
    }

    public final ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public final Double limit() {
        return this.limit;
    }

    public final AnomalySourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public final boolean hasAnomalyResources() {
        return this.anomalyResources != null && !(this.anomalyResources instanceof SdkAutoConstructList);
    }

    public final List<AnomalyResource> anomalyResources() {
        return this.anomalyResources;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyReportedTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInsightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyResources() ? this.anomalyResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProactiveAnomalySummary)) {
            return false;
        }
        ProactiveAnomalySummary other = (ProactiveAnomalySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.anomalyTimeRange(), other.anomalyTimeRange()) && Objects.equals(this.anomalyReportedTimeRange(), other.anomalyReportedTimeRange()) && Objects.equals(this.predictionTimeRange(), other.predictionTimeRange()) && Objects.equals(this.sourceDetails(), other.sourceDetails()) && Objects.equals(this.associatedInsightId(), other.associatedInsightId()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.sourceMetadata(), other.sourceMetadata()) && this.hasAnomalyResources() == other.hasAnomalyResources() && Objects.equals(this.anomalyResources(), other.anomalyResources()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ProactiveAnomalySummary").add("Id", (Object)this.id()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).add("UpdateTime", (Object)this.updateTime()).add("AnomalyTimeRange", (Object)this.anomalyTimeRange()).add("AnomalyReportedTimeRange", (Object)this.anomalyReportedTimeRange()).add("PredictionTimeRange", (Object)this.predictionTimeRange()).add("SourceDetails", (Object)this.sourceDetails()).add("AssociatedInsightId", (Object)this.associatedInsightId()).add("ResourceCollection", (Object)this.resourceCollection()).add("Limit", (Object)this.limit()).add("SourceMetadata", (Object)this.sourceMetadata()).add("AnomalyResources", this.hasAnomalyResources() ? this.anomalyResources() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "AnomalyTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyTimeRange()));
            }
            case "AnomalyReportedTimeRange": {
                return Optional.ofNullable(clazz.cast(this.anomalyReportedTimeRange()));
            }
            case "PredictionTimeRange": {
                return Optional.ofNullable(clazz.cast(this.predictionTimeRange()));
            }
            case "SourceDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceDetails()));
            }
            case "AssociatedInsightId": {
                return Optional.ofNullable(clazz.cast(this.associatedInsightId()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "SourceMetadata": {
                return Optional.ofNullable(clazz.cast(this.sourceMetadata()));
            }
            case "AnomalyResources": {
                return Optional.ofNullable(clazz.cast(this.anomalyResources()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProactiveAnomalySummary, T> g) {
        return obj -> g.apply((ProactiveAnomalySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String severity;
        private String status;
        private Instant updateTime;
        private AnomalyTimeRange anomalyTimeRange;
        private AnomalyReportedTimeRange anomalyReportedTimeRange;
        private PredictionTimeRange predictionTimeRange;
        private AnomalySourceDetails sourceDetails;
        private String associatedInsightId;
        private ResourceCollection resourceCollection;
        private Double limit;
        private AnomalySourceMetadata sourceMetadata;
        private List<AnomalyResource> anomalyResources = DefaultSdkAutoConstructList.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ProactiveAnomalySummary model) {
            this.id(model.id);
            this.severity(model.severity);
            this.status(model.status);
            this.updateTime(model.updateTime);
            this.anomalyTimeRange(model.anomalyTimeRange);
            this.anomalyReportedTimeRange(model.anomalyReportedTimeRange);
            this.predictionTimeRange(model.predictionTimeRange);
            this.sourceDetails(model.sourceDetails);
            this.associatedInsightId(model.associatedInsightId);
            this.resourceCollection(model.resourceCollection);
            this.limit(model.limit);
            this.sourceMetadata(model.sourceMetadata);
            this.anomalyResources(model.anomalyResources);
            this.description(model.description);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(AnomalySeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final AnomalyTimeRange.Builder getAnomalyTimeRange() {
            return this.anomalyTimeRange != null ? this.anomalyTimeRange.toBuilder() : null;
        }

        public final void setAnomalyTimeRange(AnomalyTimeRange.BuilderImpl anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange != null ? anomalyTimeRange.build() : null;
        }

        @Override
        public final Builder anomalyTimeRange(AnomalyTimeRange anomalyTimeRange) {
            this.anomalyTimeRange = anomalyTimeRange;
            return this;
        }

        public final AnomalyReportedTimeRange.Builder getAnomalyReportedTimeRange() {
            return this.anomalyReportedTimeRange != null ? this.anomalyReportedTimeRange.toBuilder() : null;
        }

        public final void setAnomalyReportedTimeRange(AnomalyReportedTimeRange.BuilderImpl anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange != null ? anomalyReportedTimeRange.build() : null;
        }

        @Override
        public final Builder anomalyReportedTimeRange(AnomalyReportedTimeRange anomalyReportedTimeRange) {
            this.anomalyReportedTimeRange = anomalyReportedTimeRange;
            return this;
        }

        public final PredictionTimeRange.Builder getPredictionTimeRange() {
            return this.predictionTimeRange != null ? this.predictionTimeRange.toBuilder() : null;
        }

        public final void setPredictionTimeRange(PredictionTimeRange.BuilderImpl predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange != null ? predictionTimeRange.build() : null;
        }

        @Override
        public final Builder predictionTimeRange(PredictionTimeRange predictionTimeRange) {
            this.predictionTimeRange = predictionTimeRange;
            return this;
        }

        public final AnomalySourceDetails.Builder getSourceDetails() {
            return this.sourceDetails != null ? this.sourceDetails.toBuilder() : null;
        }

        public final void setSourceDetails(AnomalySourceDetails.BuilderImpl sourceDetails) {
            this.sourceDetails = sourceDetails != null ? sourceDetails.build() : null;
        }

        @Override
        public final Builder sourceDetails(AnomalySourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            return this;
        }

        public final String getAssociatedInsightId() {
            return this.associatedInsightId;
        }

        public final void setAssociatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
        }

        @Override
        public final Builder associatedInsightId(String associatedInsightId) {
            this.associatedInsightId = associatedInsightId;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final Double getLimit() {
            return this.limit;
        }

        public final void setLimit(Double limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public final AnomalySourceMetadata.Builder getSourceMetadata() {
            return this.sourceMetadata != null ? this.sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(AnomalySourceMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(AnomalySourceMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final List<AnomalyResource.Builder> getAnomalyResources() {
            List<AnomalyResource.Builder> result = AnomalyResourcesCopier.copyToBuilder(this.anomalyResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalyResources(Collection<AnomalyResource.BuilderImpl> anomalyResources) {
            this.anomalyResources = AnomalyResourcesCopier.copyFromBuilder(anomalyResources);
        }

        @Override
        public final Builder anomalyResources(Collection<AnomalyResource> anomalyResources) {
            this.anomalyResources = AnomalyResourcesCopier.copy(anomalyResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyResources(AnomalyResource ... anomalyResources) {
            this.anomalyResources(Arrays.asList(anomalyResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyResources(Consumer<AnomalyResource.Builder> ... anomalyResources) {
            this.anomalyResources(Stream.of(anomalyResources).map(c -> (AnomalyResource)((AnomalyResource.Builder)AnomalyResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public ProactiveAnomalySummary build() {
            return new ProactiveAnomalySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProactiveAnomalySummary> {
        public Builder id(String var1);

        public Builder severity(String var1);

        public Builder severity(AnomalySeverity var1);

        public Builder status(String var1);

        public Builder status(AnomalyStatus var1);

        public Builder updateTime(Instant var1);

        public Builder anomalyTimeRange(AnomalyTimeRange var1);

        default public Builder anomalyTimeRange(Consumer<AnomalyTimeRange.Builder> anomalyTimeRange) {
            return this.anomalyTimeRange((AnomalyTimeRange)((AnomalyTimeRange.Builder)AnomalyTimeRange.builder().applyMutation(anomalyTimeRange)).build());
        }

        public Builder anomalyReportedTimeRange(AnomalyReportedTimeRange var1);

        default public Builder anomalyReportedTimeRange(Consumer<AnomalyReportedTimeRange.Builder> anomalyReportedTimeRange) {
            return this.anomalyReportedTimeRange((AnomalyReportedTimeRange)((AnomalyReportedTimeRange.Builder)AnomalyReportedTimeRange.builder().applyMutation(anomalyReportedTimeRange)).build());
        }

        public Builder predictionTimeRange(PredictionTimeRange var1);

        default public Builder predictionTimeRange(Consumer<PredictionTimeRange.Builder> predictionTimeRange) {
            return this.predictionTimeRange((PredictionTimeRange)((PredictionTimeRange.Builder)PredictionTimeRange.builder().applyMutation(predictionTimeRange)).build());
        }

        public Builder sourceDetails(AnomalySourceDetails var1);

        default public Builder sourceDetails(Consumer<AnomalySourceDetails.Builder> sourceDetails) {
            return this.sourceDetails((AnomalySourceDetails)((AnomalySourceDetails.Builder)AnomalySourceDetails.builder().applyMutation(sourceDetails)).build());
        }

        public Builder associatedInsightId(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder limit(Double var1);

        public Builder sourceMetadata(AnomalySourceMetadata var1);

        default public Builder sourceMetadata(Consumer<AnomalySourceMetadata.Builder> sourceMetadata) {
            return this.sourceMetadata((AnomalySourceMetadata)((AnomalySourceMetadata.Builder)AnomalySourceMetadata.builder().applyMutation(sourceMetadata)).build());
        }

        public Builder anomalyResources(Collection<AnomalyResource> var1);

        public Builder anomalyResources(AnomalyResource ... var1);

        public Builder anomalyResources(Consumer<AnomalyResource.Builder> ... var1);

        public Builder description(String var1);
    }
}

