/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AccountIdListCopier;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.OrganizationResourceCollectionType;
import software.amazon.awssdk.services.devopsguru.model.OrganizationalUnitIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationResourceCollectionHealthRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, DescribeOrganizationResourceCollectionHealthRequest> {
    private static final SdkField<String> ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationResourceCollectionType").getter(DescribeOrganizationResourceCollectionHealthRequest.getter(DescribeOrganizationResourceCollectionHealthRequest::organizationResourceCollectionTypeAsString)).setter(DescribeOrganizationResourceCollectionHealthRequest.setter(Builder::organizationResourceCollectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationResourceCollectionType").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(DescribeOrganizationResourceCollectionHealthRequest.getter(DescribeOrganizationResourceCollectionHealthRequest::accountIds)).setter(DescribeOrganizationResourceCollectionHealthRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitIds").getter(DescribeOrganizationResourceCollectionHealthRequest.getter(DescribeOrganizationResourceCollectionHealthRequest::organizationalUnitIds)).setter(DescribeOrganizationResourceCollectionHealthRequest.setter(Builder::organizationalUnitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationResourceCollectionHealthRequest.getter(DescribeOrganizationResourceCollectionHealthRequest::nextToken)).setter(DescribeOrganizationResourceCollectionHealthRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeOrganizationResourceCollectionHealthRequest.getter(DescribeOrganizationResourceCollectionHealthRequest::maxResults)).setter(DescribeOrganizationResourceCollectionHealthRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD, ACCOUNT_IDS_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOrganizationResourceCollectionHealthRequest.memberNameToFieldInitializer();
    private final String organizationResourceCollectionType;
    private final List<String> accountIds;
    private final List<String> organizationalUnitIds;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeOrganizationResourceCollectionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.organizationResourceCollectionType = builder.organizationResourceCollectionType;
        this.accountIds = builder.accountIds;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final OrganizationResourceCollectionType organizationResourceCollectionType() {
        return OrganizationResourceCollectionType.fromValue(this.organizationResourceCollectionType);
    }

    public final String organizationResourceCollectionTypeAsString() {
        return this.organizationResourceCollectionType;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasOrganizationalUnitIds() {
        return this.organizationalUnitIds != null && !(this.organizationalUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitIds() {
        return this.organizationalUnitIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationResourceCollectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResourceCollectionHealthRequest)) {
            return false;
        }
        DescribeOrganizationResourceCollectionHealthRequest other = (DescribeOrganizationResourceCollectionHealthRequest)((Object)obj);
        return Objects.equals(this.organizationResourceCollectionTypeAsString(), other.organizationResourceCollectionTypeAsString()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds() && Objects.equals(this.organizationalUnitIds(), other.organizationalUnitIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationResourceCollectionHealthRequest").add("OrganizationResourceCollectionType", (Object)this.organizationResourceCollectionTypeAsString()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("OrganizationalUnitIds", this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationResourceCollectionType": {
                return Optional.ofNullable(clazz.cast(this.organizationResourceCollectionTypeAsString()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "OrganizationalUnitIds": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationResourceCollectionType", ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD);
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResourceCollectionHealthRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationResourceCollectionHealthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private String organizationResourceCollectionType;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResourceCollectionHealthRequest model) {
            super(model);
            this.organizationResourceCollectionType(model.organizationResourceCollectionType);
            this.accountIds(model.accountIds);
            this.organizationalUnitIds(model.organizationalUnitIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getOrganizationResourceCollectionType() {
            return this.organizationResourceCollectionType;
        }

        public final void setOrganizationResourceCollectionType(String organizationResourceCollectionType) {
            this.organizationResourceCollectionType = organizationResourceCollectionType;
        }

        @Override
        public final Builder organizationResourceCollectionType(String organizationResourceCollectionType) {
            this.organizationResourceCollectionType = organizationResourceCollectionType;
            return this;
        }

        @Override
        public final Builder organizationResourceCollectionType(OrganizationResourceCollectionType organizationResourceCollectionType) {
            this.organizationResourceCollectionType(organizationResourceCollectionType == null ? null : organizationResourceCollectionType.toString());
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (this.organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String ... organizationalUnitIds) {
            this.organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationResourceCollectionHealthRequest build() {
            return new DescribeOrganizationResourceCollectionHealthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationResourceCollectionHealthRequest> {
        public Builder organizationResourceCollectionType(String var1);

        public Builder organizationResourceCollectionType(OrganizationResourceCollectionType var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder organizationalUnitIds(Collection<String> var1);

        public Builder organizationalUnitIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

