/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociation;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayAssociationListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectConnectGatewayAssociationsResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsResponse> {
    private static final SdkField<List<DirectConnectGatewayAssociation>> DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("directConnectGatewayAssociations").getter(DescribeDirectConnectGatewayAssociationsResponse.getter(DescribeDirectConnectGatewayAssociationsResponse::directConnectGatewayAssociations)).setter(DescribeDirectConnectGatewayAssociationsResponse.setter(Builder::directConnectGatewayAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectConnectGatewayAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDirectConnectGatewayAssociationsResponse.getter(DescribeDirectConnectGatewayAssociationsResponse::nextToken)).setter(DescribeDirectConnectGatewayAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDirectConnectGatewayAssociationsResponse.memberNameToFieldInitializer();
    private final List<DirectConnectGatewayAssociation> directConnectGatewayAssociations;
    private final String nextToken;

    private DescribeDirectConnectGatewayAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociations = builder.directConnectGatewayAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectConnectGatewayAssociations() {
        return this.directConnectGatewayAssociations != null && !(this.directConnectGatewayAssociations instanceof SdkAutoConstructList);
    }

    public final List<DirectConnectGatewayAssociation> directConnectGatewayAssociations() {
        return this.directConnectGatewayAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectConnectGatewayAssociations() ? this.directConnectGatewayAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewayAssociationsResponse)) {
            return false;
        }
        DescribeDirectConnectGatewayAssociationsResponse other = (DescribeDirectConnectGatewayAssociationsResponse)((Object)obj);
        return this.hasDirectConnectGatewayAssociations() == other.hasDirectConnectGatewayAssociations() && Objects.equals(this.directConnectGatewayAssociations(), other.directConnectGatewayAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewayAssociationsResponse").add("DirectConnectGatewayAssociations", this.hasDirectConnectGatewayAssociations() ? this.directConnectGatewayAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGatewayAssociations": {
                return Optional.ofNullable(clazz.cast(this.directConnectGatewayAssociations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("directConnectGatewayAssociations", DIRECT_CONNECT_GATEWAY_ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewayAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewayAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGatewayAssociation> directConnectGatewayAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewayAssociationsResponse model) {
            super(model);
            this.directConnectGatewayAssociations(model.directConnectGatewayAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<DirectConnectGatewayAssociation.Builder> getDirectConnectGatewayAssociations() {
            List<DirectConnectGatewayAssociation.Builder> result = DirectConnectGatewayAssociationListCopier.copyToBuilder(this.directConnectGatewayAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation.BuilderImpl> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier.copyFromBuilder(directConnectGatewayAssociations);
        }

        @Override
        public final Builder directConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation> directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations = DirectConnectGatewayAssociationListCopier.copy(directConnectGatewayAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation ... directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations(Arrays.asList(directConnectGatewayAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGatewayAssociations(Consumer<DirectConnectGatewayAssociation.Builder> ... directConnectGatewayAssociations) {
            this.directConnectGatewayAssociations(Stream.of(directConnectGatewayAssociations).map(c -> (DirectConnectGatewayAssociation)((DirectConnectGatewayAssociation.Builder)DirectConnectGatewayAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewayAssociationsResponse build() {
            return new DescribeDirectConnectGatewayAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectConnectGatewayAssociationsResponse> {
        public Builder directConnectGatewayAssociations(Collection<DirectConnectGatewayAssociation> var1);

        public Builder directConnectGatewayAssociations(DirectConnectGatewayAssociation ... var1);

        public Builder directConnectGatewayAssociations(Consumer<DirectConnectGatewayAssociation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

