/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrustDirection {
    ONE_WAY_OUTGOING("One-Way: Outgoing"),
    ONE_WAY_INCOMING("One-Way: Incoming"),
    TWO_WAY("Two-Way"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrustDirection> VALUE_MAP;
    private final String value;

    private TrustDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrustDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrustDirection> knownValues() {
        EnumSet<TrustDirection> knownValues = EnumSet.allOf(TrustDirection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrustDirection.class, TrustDirection::toString);
    }
}

