/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ShareMethod {
    ORGANIZATIONS("ORGANIZATIONS"),
    HANDSHAKE("HANDSHAKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ShareMethod> VALUE_MAP;
    private final String value;

    private ShareMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ShareMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ShareMethod> knownValues() {
        EnumSet<ShareMethod> knownValues = EnumSet.allOf(ShareMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ShareMethod.class, ShareMethod::toString);
    }
}

