/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.directory.model.DirectoryConfigurationSettingRequestDetailedStatusCopier;
import software.amazon.awssdk.services.directory.model.DirectoryConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SettingEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SettingEntry> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SettingEntry.getter(SettingEntry::type)).setter(SettingEntry.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SettingEntry.getter(SettingEntry::name)).setter(SettingEntry.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedValues").getter(SettingEntry.getter(SettingEntry::allowedValues)).setter(SettingEntry.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final SdkField<String> APPLIED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppliedValue").getter(SettingEntry.getter(SettingEntry::appliedValue)).setter(SettingEntry.setter(Builder::appliedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedValue").build()}).build();
    private static final SdkField<String> REQUESTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedValue").getter(SettingEntry.getter(SettingEntry::requestedValue)).setter(SettingEntry.setter(Builder::requestedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedValue").build()}).build();
    private static final SdkField<String> REQUEST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestStatus").getter(SettingEntry.getter(SettingEntry::requestStatusAsString)).setter(SettingEntry.setter(Builder::requestStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestStatus").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RequestDetailedStatus").getter(SettingEntry.getter(SettingEntry::requestDetailedStatusAsStrings)).setter(SettingEntry.setter(Builder::requestDetailedStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestDetailedStatus").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestStatusMessage").getter(SettingEntry.getter(SettingEntry::requestStatusMessage)).setter(SettingEntry.setter(Builder::requestStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestStatusMessage").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(SettingEntry.getter(SettingEntry::lastUpdatedDateTime)).setter(SettingEntry.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final SdkField<Instant> LAST_REQUESTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRequestedDateTime").getter(SettingEntry.getter(SettingEntry::lastRequestedDateTime)).setter(SettingEntry.setter(Builder::lastRequestedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRequestedDateTime").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(SettingEntry.getter(SettingEntry::dataType)).setter(SettingEntry.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, ALLOWED_VALUES_FIELD, APPLIED_VALUE_FIELD, REQUESTED_VALUE_FIELD, REQUEST_STATUS_FIELD, REQUEST_DETAILED_STATUS_FIELD, REQUEST_STATUS_MESSAGE_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LAST_REQUESTED_DATE_TIME_FIELD, DATA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String allowedValues;
    private final String appliedValue;
    private final String requestedValue;
    private final String requestStatus;
    private final Map<String, String> requestDetailedStatus;
    private final String requestStatusMessage;
    private final Instant lastUpdatedDateTime;
    private final Instant lastRequestedDateTime;
    private final String dataType;

    private SettingEntry(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.allowedValues = builder.allowedValues;
        this.appliedValue = builder.appliedValue;
        this.requestedValue = builder.requestedValue;
        this.requestStatus = builder.requestStatus;
        this.requestDetailedStatus = builder.requestDetailedStatus;
        this.requestStatusMessage = builder.requestStatusMessage;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.lastRequestedDateTime = builder.lastRequestedDateTime;
        this.dataType = builder.dataType;
    }

    public final String type() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String allowedValues() {
        return this.allowedValues;
    }

    public final String appliedValue() {
        return this.appliedValue;
    }

    public final String requestedValue() {
        return this.requestedValue;
    }

    public final DirectoryConfigurationStatus requestStatus() {
        return DirectoryConfigurationStatus.fromValue(this.requestStatus);
    }

    public final String requestStatusAsString() {
        return this.requestStatus;
    }

    public final Map<String, DirectoryConfigurationStatus> requestDetailedStatus() {
        return DirectoryConfigurationSettingRequestDetailedStatusCopier.copyStringToEnum(this.requestDetailedStatus);
    }

    public final boolean hasRequestDetailedStatus() {
        return this.requestDetailedStatus != null && !(this.requestDetailedStatus instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestDetailedStatusAsStrings() {
        return this.requestDetailedStatus;
    }

    public final String requestStatusMessage() {
        return this.requestStatusMessage;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final Instant lastRequestedDateTime() {
        return this.lastRequestedDateTime;
    }

    public final String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestDetailedStatus() ? this.requestDetailedStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRequestedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SettingEntry)) {
            return false;
        }
        SettingEntry other = (SettingEntry)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.appliedValue(), other.appliedValue()) && Objects.equals(this.requestedValue(), other.requestedValue()) && Objects.equals(this.requestStatusAsString(), other.requestStatusAsString()) && this.hasRequestDetailedStatus() == other.hasRequestDetailedStatus() && Objects.equals(this.requestDetailedStatusAsStrings(), other.requestDetailedStatusAsStrings()) && Objects.equals(this.requestStatusMessage(), other.requestStatusMessage()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.lastRequestedDateTime(), other.lastRequestedDateTime()) && Objects.equals(this.dataType(), other.dataType());
    }

    public final String toString() {
        return ToString.builder((String)"SettingEntry").add("Type", (Object)this.type()).add("Name", (Object)this.name()).add("AllowedValues", (Object)this.allowedValues()).add("AppliedValue", (Object)this.appliedValue()).add("RequestedValue", (Object)this.requestedValue()).add("RequestStatus", (Object)this.requestStatusAsString()).add("RequestDetailedStatus", this.hasRequestDetailedStatus() ? this.requestDetailedStatusAsStrings() : null).add("RequestStatusMessage", (Object)this.requestStatusMessage()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("LastRequestedDateTime", (Object)this.lastRequestedDateTime()).add("DataType", (Object)this.dataType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "AppliedValue": {
                return Optional.ofNullable(clazz.cast(this.appliedValue()));
            }
            case "RequestedValue": {
                return Optional.ofNullable(clazz.cast(this.requestedValue()));
            }
            case "RequestStatus": {
                return Optional.ofNullable(clazz.cast(this.requestStatusAsString()));
            }
            case "RequestDetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.requestDetailedStatusAsStrings()));
            }
            case "RequestStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.requestStatusMessage()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "LastRequestedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastRequestedDateTime()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SettingEntry, T> g) {
        return obj -> g.apply((SettingEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String allowedValues;
        private String appliedValue;
        private String requestedValue;
        private String requestStatus;
        private Map<String, String> requestDetailedStatus = DefaultSdkAutoConstructMap.getInstance();
        private String requestStatusMessage;
        private Instant lastUpdatedDateTime;
        private Instant lastRequestedDateTime;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(SettingEntry model) {
            this.type(model.type);
            this.name(model.name);
            this.allowedValues(model.allowedValues);
            this.appliedValue(model.appliedValue);
            this.requestedValue(model.requestedValue);
            this.requestStatus(model.requestStatus);
            this.requestDetailedStatusWithStrings(model.requestDetailedStatus);
            this.requestStatusMessage(model.requestStatusMessage);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.lastRequestedDateTime(model.lastRequestedDateTime);
            this.dataType(model.dataType);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final String getAppliedValue() {
            return this.appliedValue;
        }

        public final void setAppliedValue(String appliedValue) {
            this.appliedValue = appliedValue;
        }

        @Override
        public final Builder appliedValue(String appliedValue) {
            this.appliedValue = appliedValue;
            return this;
        }

        public final String getRequestedValue() {
            return this.requestedValue;
        }

        public final void setRequestedValue(String requestedValue) {
            this.requestedValue = requestedValue;
        }

        @Override
        public final Builder requestedValue(String requestedValue) {
            this.requestedValue = requestedValue;
            return this;
        }

        public final String getRequestStatus() {
            return this.requestStatus;
        }

        public final void setRequestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
        }

        @Override
        public final Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            return this;
        }

        @Override
        public final Builder requestStatus(DirectoryConfigurationStatus requestStatus) {
            this.requestStatus(requestStatus == null ? null : requestStatus.toString());
            return this;
        }

        public final Map<String, String> getRequestDetailedStatus() {
            if (this.requestDetailedStatus instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestDetailedStatus;
        }

        public final void setRequestDetailedStatus(Map<String, String> requestDetailedStatus) {
            this.requestDetailedStatus = DirectoryConfigurationSettingRequestDetailedStatusCopier.copy(requestDetailedStatus);
        }

        @Override
        public final Builder requestDetailedStatusWithStrings(Map<String, String> requestDetailedStatus) {
            this.requestDetailedStatus = DirectoryConfigurationSettingRequestDetailedStatusCopier.copy(requestDetailedStatus);
            return this;
        }

        @Override
        public final Builder requestDetailedStatus(Map<String, DirectoryConfigurationStatus> requestDetailedStatus) {
            this.requestDetailedStatus = DirectoryConfigurationSettingRequestDetailedStatusCopier.copyEnumToString(requestDetailedStatus);
            return this;
        }

        public final String getRequestStatusMessage() {
            return this.requestStatusMessage;
        }

        public final void setRequestStatusMessage(String requestStatusMessage) {
            this.requestStatusMessage = requestStatusMessage;
        }

        @Override
        public final Builder requestStatusMessage(String requestStatusMessage) {
            this.requestStatusMessage = requestStatusMessage;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final Instant getLastRequestedDateTime() {
            return this.lastRequestedDateTime;
        }

        public final void setLastRequestedDateTime(Instant lastRequestedDateTime) {
            this.lastRequestedDateTime = lastRequestedDateTime;
        }

        @Override
        public final Builder lastRequestedDateTime(Instant lastRequestedDateTime) {
            this.lastRequestedDateTime = lastRequestedDateTime;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public SettingEntry build() {
            return new SettingEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SettingEntry> {
        public Builder type(String var1);

        public Builder name(String var1);

        public Builder allowedValues(String var1);

        public Builder appliedValue(String var1);

        public Builder requestedValue(String var1);

        public Builder requestStatus(String var1);

        public Builder requestStatus(DirectoryConfigurationStatus var1);

        public Builder requestDetailedStatusWithStrings(Map<String, String> var1);

        public Builder requestDetailedStatus(Map<String, DirectoryConfigurationStatus> var1);

        public Builder requestStatusMessage(String var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder lastRequestedDateTime(Instant var1);

        public Builder dataType(String var1);
    }
}

