/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.RegionDescription;

public class DescribeRegionsPublisher
implements SdkPublisher<DescribeRegionsResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeRegionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegionsPublisher(DirectoryAsyncClient client, DescribeRegionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegionsPublisher(DirectoryAsyncClient client, DescribeRegionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegionDescription> regionsDescription() {
        Function<DescribeRegionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.regionsDescription() != null) {
                return response.regionsDescription().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegionsResponseFetcher
    implements AsyncPageFetcher<DescribeRegionsResponse> {
        private DescribeRegionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegionsResponse> nextPage(DescribeRegionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegionsPublisher.this.client.describeRegions(DescribeRegionsPublisher.this.firstRequest);
            }
            return DescribeRegionsPublisher.this.client.describeRegions((DescribeRegionsRequest)((Object)DescribeRegionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

