/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.DefaultPoliciesTypeValues;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.PolicyIdListCopier;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValuesListCopier;
import software.amazon.awssdk.services.dlm.model.TagsToAddFilterListCopier;
import software.amazon.awssdk.services.dlm.model.TargetTagsFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLifecyclePoliciesRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, GetLifecyclePoliciesRequest> {
    private static final SdkField<List<String>> POLICY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyIds").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::policyIds)).setter(GetLifecyclePoliciesRequest.setter(Builder::policyIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::stateAsString)).setter(GetLifecyclePoliciesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::resourceTypesAsStrings)).setter(GetLifecyclePoliciesRequest.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetTags").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::targetTags)).setter(GetLifecyclePoliciesRequest.setter(Builder::targetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAGS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagsToAdd").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::tagsToAdd)).setter(GetLifecyclePoliciesRequest.setter(Builder::tagsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("tagsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultPolicyType").getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::defaultPolicyTypeAsString)).setter(GetLifecyclePoliciesRequest.setter(Builder::defaultPolicyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("defaultPolicyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IDS_FIELD, STATE_FIELD, RESOURCE_TYPES_FIELD, TARGET_TAGS_FIELD, TAGS_TO_ADD_FIELD, DEFAULT_POLICY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyIds", POLICY_IDS_FIELD);
            this.put("state", STATE_FIELD);
            this.put("resourceTypes", RESOURCE_TYPES_FIELD);
            this.put("targetTags", TARGET_TAGS_FIELD);
            this.put("tagsToAdd", TAGS_TO_ADD_FIELD);
            this.put("defaultPolicyType", DEFAULT_POLICY_TYPE_FIELD);
        }
    });
    private final List<String> policyIds;
    private final String state;
    private final List<String> resourceTypes;
    private final List<String> targetTags;
    private final List<String> tagsToAdd;
    private final String defaultPolicyType;

    private GetLifecyclePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyIds = builder.policyIds;
        this.state = builder.state;
        this.resourceTypes = builder.resourceTypes;
        this.targetTags = builder.targetTags;
        this.tagsToAdd = builder.tagsToAdd;
        this.defaultPolicyType = builder.defaultPolicyType;
    }

    public final boolean hasPolicyIds() {
        return this.policyIds != null && !(this.policyIds instanceof SdkAutoConstructList);
    }

    public final List<String> policyIds() {
        return this.policyIds;
    }

    public final GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final boolean hasTargetTags() {
        return this.targetTags != null && !(this.targetTags instanceof SdkAutoConstructList);
    }

    public final List<String> targetTags() {
        return this.targetTags;
    }

    public final boolean hasTagsToAdd() {
        return this.tagsToAdd != null && !(this.tagsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> tagsToAdd() {
        return this.tagsToAdd;
    }

    public final DefaultPoliciesTypeValues defaultPolicyType() {
        return DefaultPoliciesTypeValues.fromValue(this.defaultPolicyType);
    }

    public final String defaultPolicyTypeAsString() {
        return this.defaultPolicyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyIds() ? this.policyIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTags() ? this.targetTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagsToAdd() ? this.tagsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultPolicyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesRequest)) {
            return false;
        }
        GetLifecyclePoliciesRequest other = (GetLifecyclePoliciesRequest)((Object)obj);
        return this.hasPolicyIds() == other.hasPolicyIds() && Objects.equals(this.policyIds(), other.policyIds()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasTargetTags() == other.hasTargetTags() && Objects.equals(this.targetTags(), other.targetTags()) && this.hasTagsToAdd() == other.hasTagsToAdd() && Objects.equals(this.tagsToAdd(), other.tagsToAdd()) && Objects.equals(this.defaultPolicyTypeAsString(), other.defaultPolicyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetLifecyclePoliciesRequest").add("PolicyIds", this.hasPolicyIds() ? this.policyIds() : null).add("State", (Object)this.stateAsString()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("TargetTags", this.hasTargetTags() ? this.targetTags() : null).add("TagsToAdd", this.hasTagsToAdd() ? this.tagsToAdd() : null).add("DefaultPolicyType", (Object)this.defaultPolicyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyIds": {
                return Optional.ofNullable(clazz.cast(this.policyIds()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "TargetTags": {
                return Optional.ofNullable(clazz.cast(this.targetTags()));
            }
            case "TagsToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagsToAdd()));
            }
            case "DefaultPolicyType": {
                return Optional.ofNullable(clazz.cast(this.defaultPolicyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePoliciesRequest, T> g) {
        return obj -> g.apply((GetLifecyclePoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private List<String> policyIds = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagsToAdd = DefaultSdkAutoConstructList.getInstance();
        private String defaultPolicyType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePoliciesRequest model) {
            super(model);
            this.policyIds(model.policyIds);
            this.state(model.state);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.targetTags(model.targetTags);
            this.tagsToAdd(model.tagsToAdd);
            this.defaultPolicyType(model.defaultPolicyType);
        }

        public final Collection<String> getPolicyIds() {
            if (this.policyIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyIds;
        }

        public final void setPolicyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
        }

        @Override
        public final Builder policyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyIds(String ... policyIds) {
            this.policyIds(Arrays.asList(policyIds));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getTargetTags() {
            if (this.targetTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetTags;
        }

        public final void setTargetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
        }

        @Override
        public final Builder targetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(String ... targetTags) {
            this.targetTags(Arrays.asList(targetTags));
            return this;
        }

        public final Collection<String> getTagsToAdd() {
            if (this.tagsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagsToAdd;
        }

        public final void setTagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
        }

        @Override
        public final Builder tagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(String ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        public final String getDefaultPolicyType() {
            return this.defaultPolicyType;
        }

        public final void setDefaultPolicyType(String defaultPolicyType) {
            this.defaultPolicyType = defaultPolicyType;
        }

        @Override
        public final Builder defaultPolicyType(String defaultPolicyType) {
            this.defaultPolicyType = defaultPolicyType;
            return this;
        }

        @Override
        public final Builder defaultPolicyType(DefaultPoliciesTypeValues defaultPolicyType) {
            this.defaultPolicyType(defaultPolicyType == null ? null : defaultPolicyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLifecyclePoliciesRequest build() {
            return new GetLifecyclePoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLifecyclePoliciesRequest> {
        public Builder policyIds(Collection<String> var1);

        public Builder policyIds(String ... var1);

        public Builder state(String var1);

        public Builder state(GettablePolicyStateValues var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceTypeValues> var1);

        public Builder resourceTypes(ResourceTypeValues ... var1);

        public Builder targetTags(Collection<String> var1);

        public Builder targetTags(String ... var1);

        public Builder tagsToAdd(Collection<String> var1);

        public Builder tagsToAdd(String ... var1);

        public Builder defaultPolicyType(String var1);

        public Builder defaultPolicyType(DefaultPoliciesTypeValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

