/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Default policies only]</b> Specifies exclusion parameters for volumes or instances for which you do not want to
 * create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the
 * specified exclusion parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Exclusions implements SdkPojo, Serializable, ToCopyableBuilder<Exclusions.Builder, Exclusions> {
    private static final SdkField<Boolean> EXCLUDE_BOOT_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeBootVolumes").getter(getter(Exclusions::excludeBootVolumes))
            .setter(setter(Builder::excludeBootVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeBootVolumes").build())
            .build();

    private static final SdkField<List<String>> EXCLUDE_VOLUME_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeVolumeTypes")
            .getter(getter(Exclusions::excludeVolumeTypes))
            .setter(setter(Builder::excludeVolumeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeVolumeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> EXCLUDE_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("ExcludeTags")
            .getter(getter(Exclusions::excludeTags))
            .setter(setter(Builder::excludeTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDE_BOOT_VOLUMES_FIELD,
            EXCLUDE_VOLUME_TYPES_FIELD, EXCLUDE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean excludeBootVolumes;

    private final List<String> excludeVolumeTypes;

    private final List<Tag> excludeTags;

    private Exclusions(BuilderImpl builder) {
        this.excludeBootVolumes = builder.excludeBootVolumes;
        this.excludeVolumeTypes = builder.excludeVolumeTypes;
        this.excludeTags = builder.excludeTags;
    }

    /**
     * <p>
     * <b>[Default policies for EBS snapshots only]</b> Indicates whether to exclude volumes that are attached to
     * instances as the boot volume. If you exclude boot volumes, only volumes attached as data (non-boot) volumes will
     * be backed up by the policy. To exclude boot volumes, specify <code>true</code>.
     * </p>
     * 
     * @return <b>[Default policies for EBS snapshots only]</b> Indicates whether to exclude volumes that are attached
     *         to instances as the boot volume. If you exclude boot volumes, only volumes attached as data (non-boot)
     *         volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code>.
     */
    public final Boolean excludeBootVolumes() {
        return excludeBootVolumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeVolumeTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeVolumeTypes() {
        return excludeVolumeTypes != null && !(excludeVolumeTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the specified
     * types will not be targeted by the policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeVolumeTypes} method.
     * </p>
     * 
     * @return <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the
     *         specified types will not be targeted by the policy.
     */
    public final List<String> excludeVolumeTypes() {
        return excludeVolumeTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeTags() {
        return excludeTags != null && !(excludeTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have specific tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeTags} method.
     * </p>
     * 
     * @return <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have
     *         specific tags.
     */
    public final List<Tag> excludeTags() {
        return excludeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludeBootVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeVolumeTypes() ? excludeVolumeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeTags() ? excludeTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Exclusions)) {
            return false;
        }
        Exclusions other = (Exclusions) obj;
        return Objects.equals(excludeBootVolumes(), other.excludeBootVolumes())
                && hasExcludeVolumeTypes() == other.hasExcludeVolumeTypes()
                && Objects.equals(excludeVolumeTypes(), other.excludeVolumeTypes()) && hasExcludeTags() == other.hasExcludeTags()
                && Objects.equals(excludeTags(), other.excludeTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Exclusions").add("ExcludeBootVolumes", excludeBootVolumes())
                .add("ExcludeVolumeTypes", hasExcludeVolumeTypes() ? excludeVolumeTypes() : null)
                .add("ExcludeTags", hasExcludeTags() ? excludeTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcludeBootVolumes":
            return Optional.ofNullable(clazz.cast(excludeBootVolumes()));
        case "ExcludeVolumeTypes":
            return Optional.ofNullable(clazz.cast(excludeVolumeTypes()));
        case "ExcludeTags":
            return Optional.ofNullable(clazz.cast(excludeTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExcludeBootVolumes", EXCLUDE_BOOT_VOLUMES_FIELD);
        map.put("ExcludeVolumeTypes", EXCLUDE_VOLUME_TYPES_FIELD);
        map.put("ExcludeTags", EXCLUDE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Exclusions, T> g) {
        return obj -> g.apply((Exclusions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Exclusions> {
        /**
         * <p>
         * <b>[Default policies for EBS snapshots only]</b> Indicates whether to exclude volumes that are attached to
         * instances as the boot volume. If you exclude boot volumes, only volumes attached as data (non-boot) volumes
         * will be backed up by the policy. To exclude boot volumes, specify <code>true</code>.
         * </p>
         * 
         * @param excludeBootVolumes
         *        <b>[Default policies for EBS snapshots only]</b> Indicates whether to exclude volumes that are
         *        attached to instances as the boot volume. If you exclude boot volumes, only volumes attached as data
         *        (non-boot) volumes will be backed up by the policy. To exclude boot volumes, specify <code>true</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeBootVolumes(Boolean excludeBootVolumes);

        /**
         * <p>
         * <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the
         * specified types will not be targeted by the policy.
         * </p>
         * 
         * @param excludeVolumeTypes
         *        <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the
         *        specified types will not be targeted by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeVolumeTypes(Collection<String> excludeVolumeTypes);

        /**
         * <p>
         * <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the
         * specified types will not be targeted by the policy.
         * </p>
         * 
         * @param excludeVolumeTypes
         *        <b>[Default policies for EBS snapshots only]</b> Specifies the volume types to exclude. Volumes of the
         *        specified types will not be targeted by the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeVolumeTypes(String... excludeVolumeTypes);

        /**
         * <p>
         * <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have specific
         * tags.
         * </p>
         * 
         * @param excludeTags
         *        <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have
         *        specific tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeTags(Collection<Tag> excludeTags);

        /**
         * <p>
         * <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have specific
         * tags.
         * </p>
         * 
         * @param excludeTags
         *        <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have
         *        specific tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeTags(Tag... excludeTags);

        /**
         * <p>
         * <b>[Default policies for EBS-backed AMIs only]</b> Specifies whether to exclude volumes that have specific
         * tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dlm.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.dlm.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.dlm.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #excludeTags(List<Tag>)}.
         * 
         * @param excludeTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.dlm.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeTags(java.util.Collection<Tag>)
         */
        Builder excludeTags(Consumer<Tag.Builder>... excludeTags);
    }

    static final class BuilderImpl implements Builder {
        private Boolean excludeBootVolumes;

        private List<String> excludeVolumeTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> excludeTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Exclusions model) {
            excludeBootVolumes(model.excludeBootVolumes);
            excludeVolumeTypes(model.excludeVolumeTypes);
            excludeTags(model.excludeTags);
        }

        public final Boolean getExcludeBootVolumes() {
            return excludeBootVolumes;
        }

        public final void setExcludeBootVolumes(Boolean excludeBootVolumes) {
            this.excludeBootVolumes = excludeBootVolumes;
        }

        @Override
        public final Builder excludeBootVolumes(Boolean excludeBootVolumes) {
            this.excludeBootVolumes = excludeBootVolumes;
            return this;
        }

        public final Collection<String> getExcludeVolumeTypes() {
            if (excludeVolumeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeVolumeTypes;
        }

        public final void setExcludeVolumeTypes(Collection<String> excludeVolumeTypes) {
            this.excludeVolumeTypes = ExcludeVolumeTypesListCopier.copy(excludeVolumeTypes);
        }

        @Override
        public final Builder excludeVolumeTypes(Collection<String> excludeVolumeTypes) {
            this.excludeVolumeTypes = ExcludeVolumeTypesListCopier.copy(excludeVolumeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeVolumeTypes(String... excludeVolumeTypes) {
            excludeVolumeTypes(Arrays.asList(excludeVolumeTypes));
            return this;
        }

        public final List<Tag.Builder> getExcludeTags() {
            List<Tag.Builder> result = ExcludeTagsListCopier.copyToBuilder(this.excludeTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeTags(Collection<Tag.BuilderImpl> excludeTags) {
            this.excludeTags = ExcludeTagsListCopier.copyFromBuilder(excludeTags);
        }

        @Override
        public final Builder excludeTags(Collection<Tag> excludeTags) {
            this.excludeTags = ExcludeTagsListCopier.copy(excludeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeTags(Tag... excludeTags) {
            excludeTags(Arrays.asList(excludeTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeTags(Consumer<Tag.Builder>... excludeTags) {
            excludeTags(Stream.of(excludeTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Exclusions build() {
            return new Exclusions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
