/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum AMITypes {
    AL2_X86_64("AL2_x86_64"),

    AL2_X86_64_GPU("AL2_x86_64_GPU"),

    AL2_ARM_64("AL2_ARM_64"),

    CUSTOM("CUSTOM"),

    BOTTLEROCKET_ARM_64("BOTTLEROCKET_ARM_64"),

    BOTTLEROCKET_X86_64("BOTTLEROCKET_x86_64"),

    BOTTLEROCKET_ARM_64_NVIDIA("BOTTLEROCKET_ARM_64_NVIDIA"),

    BOTTLEROCKET_X86_64_NVIDIA("BOTTLEROCKET_x86_64_NVIDIA"),

    WINDOWS_CORE_2019_X86_64("WINDOWS_CORE_2019_x86_64"),

    WINDOWS_FULL_2019_X86_64("WINDOWS_FULL_2019_x86_64"),

    WINDOWS_CORE_2022_X86_64("WINDOWS_CORE_2022_x86_64"),

    WINDOWS_FULL_2022_X86_64("WINDOWS_FULL_2022_x86_64"),

    AL2023_X86_64_STANDARD("AL2023_x86_64_STANDARD"),

    AL2023_ARM_64_STANDARD("AL2023_ARM_64_STANDARD"),

    AL2023_X86_64_NEURON("AL2023_x86_64_NEURON"),

    AL2023_X86_64_NVIDIA("AL2023_x86_64_NVIDIA"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AMITypes> VALUE_MAP = EnumUtils.uniqueIndex(AMITypes.class, AMITypes::toString);

    private final String value;

    private AMITypes(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AMITypes corresponding to the value
     */
    public static AMITypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AMITypes}s
     */
    public static Set<AMITypes> knownValues() {
        Set<AMITypes> knownValues = EnumSet.allOf(AMITypes.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
