/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a specific EKS cluster version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterVersionInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterVersionInformation.Builder, ClusterVersionInformation> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterVersion").getter(getter(ClusterVersionInformation::clusterVersion))
            .setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterVersion").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(ClusterVersionInformation::clusterType))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()).build();

    private static final SdkField<String> DEFAULT_PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultPlatformVersion").getter(getter(ClusterVersionInformation::defaultPlatformVersion))
            .setter(setter(Builder::defaultPlatformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultPlatformVersion").build())
            .build();

    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("defaultVersion").getter(getter(ClusterVersionInformation::defaultVersion))
            .setter(setter(Builder::defaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()).build();

    private static final SdkField<Instant> RELEASE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("releaseDate").getter(getter(ClusterVersionInformation::releaseDate))
            .setter(setter(Builder::releaseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseDate").build()).build();

    private static final SdkField<Instant> END_OF_STANDARD_SUPPORT_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("endOfStandardSupportDate")
            .getter(getter(ClusterVersionInformation::endOfStandardSupportDate))
            .setter(setter(Builder::endOfStandardSupportDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOfStandardSupportDate").build())
            .build();

    private static final SdkField<Instant> END_OF_EXTENDED_SUPPORT_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("endOfExtendedSupportDate")
            .getter(getter(ClusterVersionInformation::endOfExtendedSupportDate))
            .setter(setter(Builder::endOfExtendedSupportDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endOfExtendedSupportDate").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ClusterVersionInformation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionStatus").getter(getter(ClusterVersionInformation::versionStatusAsString))
            .setter(setter(Builder::versionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionStatus").build()).build();

    private static final SdkField<String> KUBERNETES_PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kubernetesPatchVersion").getter(getter(ClusterVersionInformation::kubernetesPatchVersion))
            .setter(setter(Builder::kubernetesPatchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesPatchVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD,
            CLUSTER_TYPE_FIELD, DEFAULT_PLATFORM_VERSION_FIELD, DEFAULT_VERSION_FIELD, RELEASE_DATE_FIELD,
            END_OF_STANDARD_SUPPORT_DATE_FIELD, END_OF_EXTENDED_SUPPORT_DATE_FIELD, STATUS_FIELD, VERSION_STATUS_FIELD,
            KUBERNETES_PATCH_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterVersion;

    private final String clusterType;

    private final String defaultPlatformVersion;

    private final Boolean defaultVersion;

    private final Instant releaseDate;

    private final Instant endOfStandardSupportDate;

    private final Instant endOfExtendedSupportDate;

    private final String status;

    private final String versionStatus;

    private final String kubernetesPatchVersion;

    private ClusterVersionInformation(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterType = builder.clusterType;
        this.defaultPlatformVersion = builder.defaultPlatformVersion;
        this.defaultVersion = builder.defaultVersion;
        this.releaseDate = builder.releaseDate;
        this.endOfStandardSupportDate = builder.endOfStandardSupportDate;
        this.endOfExtendedSupportDate = builder.endOfExtendedSupportDate;
        this.status = builder.status;
        this.versionStatus = builder.versionStatus;
        this.kubernetesPatchVersion = builder.kubernetesPatchVersion;
    }

    /**
     * <p>
     * The Kubernetes version for the cluster.
     * </p>
     * 
     * @return The Kubernetes version for the cluster.
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The type of cluster this version is for.
     * </p>
     * 
     * @return The type of cluster this version is for.
     */
    public final String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * Default platform version for this Kubernetes version.
     * </p>
     * 
     * @return Default platform version for this Kubernetes version.
     */
    public final String defaultPlatformVersion() {
        return defaultPlatformVersion;
    }

    /**
     * <p>
     * Indicates if this is a default version.
     * </p>
     * 
     * @return Indicates if this is a default version.
     */
    public final Boolean defaultVersion() {
        return defaultVersion;
    }

    /**
     * <p>
     * The release date of this cluster version.
     * </p>
     * 
     * @return The release date of this cluster version.
     */
    public final Instant releaseDate() {
        return releaseDate;
    }

    /**
     * <p>
     * Date when standard support ends for this version.
     * </p>
     * 
     * @return Date when standard support ends for this version.
     */
    public final Instant endOfStandardSupportDate() {
        return endOfStandardSupportDate;
    }

    /**
     * <p>
     * Date when extended support ends for this version.
     * </p>
     * 
     * @return Date when extended support ends for this version.
     */
    public final Instant endOfExtendedSupportDate() {
        return endOfExtendedSupportDate;
    }

    /**
     * <important>
     * <p>
     * This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and output of
     * this action.
     * </p>
     * </important>
     * <p>
     * Current status of this cluster version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return <p>
     *         This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and
     *         output of this action.
     *         </p>
     *         </important>
     *         <p>
     *         Current status of this cluster version.
     * @see ClusterVersionStatus
     */
    public final ClusterVersionStatus status() {
        return ClusterVersionStatus.fromValue(status);
    }

    /**
     * <important>
     * <p>
     * This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and output of
     * this action.
     * </p>
     * </important>
     * <p>
     * Current status of this cluster version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return <p>
     *         This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and
     *         output of this action.
     *         </p>
     *         </important>
     *         <p>
     *         Current status of this cluster version.
     * @see ClusterVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Current status of this cluster version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Current status of this cluster version.
     * @see VersionStatus
     */
    public final VersionStatus versionStatus() {
        return VersionStatus.fromValue(versionStatus);
    }

    /**
     * <p>
     * Current status of this cluster version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #versionStatusAsString}.
     * </p>
     * 
     * @return Current status of this cluster version.
     * @see VersionStatus
     */
    public final String versionStatusAsString() {
        return versionStatus;
    }

    /**
     * <p>
     * The patch version of Kubernetes for this cluster version.
     * </p>
     * 
     * @return The patch version of Kubernetes for this cluster version.
     */
    public final String kubernetesPatchVersion() {
        return kubernetesPatchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPlatformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(releaseDate());
        hashCode = 31 * hashCode + Objects.hashCode(endOfStandardSupportDate());
        hashCode = 31 * hashCode + Objects.hashCode(endOfExtendedSupportDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kubernetesPatchVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterVersionInformation)) {
            return false;
        }
        ClusterVersionInformation other = (ClusterVersionInformation) obj;
        return Objects.equals(clusterVersion(), other.clusterVersion()) && Objects.equals(clusterType(), other.clusterType())
                && Objects.equals(defaultPlatformVersion(), other.defaultPlatformVersion())
                && Objects.equals(defaultVersion(), other.defaultVersion()) && Objects.equals(releaseDate(), other.releaseDate())
                && Objects.equals(endOfStandardSupportDate(), other.endOfStandardSupportDate())
                && Objects.equals(endOfExtendedSupportDate(), other.endOfExtendedSupportDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(versionStatusAsString(), other.versionStatusAsString())
                && Objects.equals(kubernetesPatchVersion(), other.kubernetesPatchVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterVersionInformation").add("ClusterVersion", clusterVersion())
                .add("ClusterType", clusterType()).add("DefaultPlatformVersion", defaultPlatformVersion())
                .add("DefaultVersion", defaultVersion()).add("ReleaseDate", releaseDate())
                .add("EndOfStandardSupportDate", endOfStandardSupportDate())
                .add("EndOfExtendedSupportDate", endOfExtendedSupportDate()).add("Status", statusAsString())
                .add("VersionStatus", versionStatusAsString()).add("KubernetesPatchVersion", kubernetesPatchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "defaultPlatformVersion":
            return Optional.ofNullable(clazz.cast(defaultPlatformVersion()));
        case "defaultVersion":
            return Optional.ofNullable(clazz.cast(defaultVersion()));
        case "releaseDate":
            return Optional.ofNullable(clazz.cast(releaseDate()));
        case "endOfStandardSupportDate":
            return Optional.ofNullable(clazz.cast(endOfStandardSupportDate()));
        case "endOfExtendedSupportDate":
            return Optional.ofNullable(clazz.cast(endOfExtendedSupportDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "versionStatus":
            return Optional.ofNullable(clazz.cast(versionStatusAsString()));
        case "kubernetesPatchVersion":
            return Optional.ofNullable(clazz.cast(kubernetesPatchVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterVersion", CLUSTER_VERSION_FIELD);
        map.put("clusterType", CLUSTER_TYPE_FIELD);
        map.put("defaultPlatformVersion", DEFAULT_PLATFORM_VERSION_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        map.put("releaseDate", RELEASE_DATE_FIELD);
        map.put("endOfStandardSupportDate", END_OF_STANDARD_SUPPORT_DATE_FIELD);
        map.put("endOfExtendedSupportDate", END_OF_EXTENDED_SUPPORT_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("versionStatus", VERSION_STATUS_FIELD);
        map.put("kubernetesPatchVersion", KUBERNETES_PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterVersionInformation, T> g) {
        return obj -> g.apply((ClusterVersionInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterVersionInformation> {
        /**
         * <p>
         * The Kubernetes version for the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The Kubernetes version for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The type of cluster this version is for.
         * </p>
         * 
         * @param clusterType
         *        The type of cluster this version is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Default platform version for this Kubernetes version.
         * </p>
         * 
         * @param defaultPlatformVersion
         *        Default platform version for this Kubernetes version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPlatformVersion(String defaultPlatformVersion);

        /**
         * <p>
         * Indicates if this is a default version.
         * </p>
         * 
         * @param defaultVersion
         *        Indicates if this is a default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersion(Boolean defaultVersion);

        /**
         * <p>
         * The release date of this cluster version.
         * </p>
         * 
         * @param releaseDate
         *        The release date of this cluster version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseDate(Instant releaseDate);

        /**
         * <p>
         * Date when standard support ends for this version.
         * </p>
         * 
         * @param endOfStandardSupportDate
         *        Date when standard support ends for this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOfStandardSupportDate(Instant endOfStandardSupportDate);

        /**
         * <p>
         * Date when extended support ends for this version.
         * </p>
         * 
         * @param endOfExtendedSupportDate
         *        Date when extended support ends for this version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOfExtendedSupportDate(Instant endOfExtendedSupportDate);

        /**
         * <important>
         * <p>
         * This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and output
         * of this action.
         * </p>
         * </important>
         * <p>
         * Current status of this cluster version.
         * </p>
         * 
         * @param status
         *        <p>
         *        This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and
         *        output of this action.
         *        </p>
         *        </important>
         *        <p>
         *        Current status of this cluster version.
         * @see ClusterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterVersionStatus
         */
        Builder status(String status);

        /**
         * <important>
         * <p>
         * This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and output
         * of this action.
         * </p>
         * </important>
         * <p>
         * Current status of this cluster version.
         * </p>
         * 
         * @param status
         *        <p>
         *        This field is deprecated. Use <code>versionStatus</code> instead, as that field matches for input and
         *        output of this action.
         *        </p>
         *        </important>
         *        <p>
         *        Current status of this cluster version.
         * @see ClusterVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterVersionStatus
         */
        Builder status(ClusterVersionStatus status);

        /**
         * <p>
         * Current status of this cluster version.
         * </p>
         * 
         * @param versionStatus
         *        Current status of this cluster version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder versionStatus(String versionStatus);

        /**
         * <p>
         * Current status of this cluster version.
         * </p>
         * 
         * @param versionStatus
         *        Current status of this cluster version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder versionStatus(VersionStatus versionStatus);

        /**
         * <p>
         * The patch version of Kubernetes for this cluster version.
         * </p>
         * 
         * @param kubernetesPatchVersion
         *        The patch version of Kubernetes for this cluster version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kubernetesPatchVersion(String kubernetesPatchVersion);
    }

    static final class BuilderImpl implements Builder {
        private String clusterVersion;

        private String clusterType;

        private String defaultPlatformVersion;

        private Boolean defaultVersion;

        private Instant releaseDate;

        private Instant endOfStandardSupportDate;

        private Instant endOfExtendedSupportDate;

        private String status;

        private String versionStatus;

        private String kubernetesPatchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterVersionInformation model) {
            clusterVersion(model.clusterVersion);
            clusterType(model.clusterType);
            defaultPlatformVersion(model.defaultPlatformVersion);
            defaultVersion(model.defaultVersion);
            releaseDate(model.releaseDate);
            endOfStandardSupportDate(model.endOfStandardSupportDate);
            endOfExtendedSupportDate(model.endOfExtendedSupportDate);
            status(model.status);
            versionStatus(model.versionStatus);
            kubernetesPatchVersion(model.kubernetesPatchVersion);
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getDefaultPlatformVersion() {
            return defaultPlatformVersion;
        }

        public final void setDefaultPlatformVersion(String defaultPlatformVersion) {
            this.defaultPlatformVersion = defaultPlatformVersion;
        }

        @Override
        public final Builder defaultPlatformVersion(String defaultPlatformVersion) {
            this.defaultPlatformVersion = defaultPlatformVersion;
            return this;
        }

        public final Boolean getDefaultVersion() {
            return defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final Instant getReleaseDate() {
            return releaseDate;
        }

        public final void setReleaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
        }

        @Override
        public final Builder releaseDate(Instant releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public final Instant getEndOfStandardSupportDate() {
            return endOfStandardSupportDate;
        }

        public final void setEndOfStandardSupportDate(Instant endOfStandardSupportDate) {
            this.endOfStandardSupportDate = endOfStandardSupportDate;
        }

        @Override
        public final Builder endOfStandardSupportDate(Instant endOfStandardSupportDate) {
            this.endOfStandardSupportDate = endOfStandardSupportDate;
            return this;
        }

        public final Instant getEndOfExtendedSupportDate() {
            return endOfExtendedSupportDate;
        }

        public final void setEndOfExtendedSupportDate(Instant endOfExtendedSupportDate) {
            this.endOfExtendedSupportDate = endOfExtendedSupportDate;
        }

        @Override
        public final Builder endOfExtendedSupportDate(Instant endOfExtendedSupportDate) {
            this.endOfExtendedSupportDate = endOfExtendedSupportDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersionStatus() {
            return versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(VersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public final String getKubernetesPatchVersion() {
            return kubernetesPatchVersion;
        }

        public final void setKubernetesPatchVersion(String kubernetesPatchVersion) {
            this.kubernetesPatchVersion = kubernetesPatchVersion;
        }

        @Override
        public final Builder kubernetesPatchVersion(String kubernetesPatchVersion) {
            this.kubernetesPatchVersion = kubernetesPatchVersion;
            return this;
        }

        @Override
        public ClusterVersionInformation build() {
            return new ClusterVersionInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
