/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information that relates to the category of the insight. Currently only returned with certain insights having
 * category <code>UPGRADE_READINESS</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsightCategorySpecificSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InsightCategorySpecificSummary.Builder, InsightCategorySpecificSummary> {
    private static final SdkField<List<DeprecationDetail>> DEPRECATION_DETAILS_FIELD = SdkField
            .<List<DeprecationDetail>> builder(MarshallingType.LIST)
            .memberName("deprecationDetails")
            .getter(getter(InsightCategorySpecificSummary::deprecationDetails))
            .setter(setter(Builder::deprecationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeprecationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeprecationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddonCompatibilityDetail>> ADDON_COMPATIBILITY_DETAILS_FIELD = SdkField
            .<List<AddonCompatibilityDetail>> builder(MarshallingType.LIST)
            .memberName("addonCompatibilityDetails")
            .getter(getter(InsightCategorySpecificSummary::addonCompatibilityDetails))
            .setter(setter(Builder::addonCompatibilityDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addonCompatibilityDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddonCompatibilityDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddonCompatibilityDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPRECATION_DETAILS_FIELD,
            ADDON_COMPATIBILITY_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DeprecationDetail> deprecationDetails;

    private final List<AddonCompatibilityDetail> addonCompatibilityDetails;

    private InsightCategorySpecificSummary(BuilderImpl builder) {
        this.deprecationDetails = builder.deprecationDetails;
        this.addonCompatibilityDetails = builder.addonCompatibilityDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeprecationDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeprecationDetails() {
        return deprecationDetails != null && !(deprecationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary information about deprecated resource usage for an insight check in the
     * <code>UPGRADE_READINESS</code> category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeprecationDetails} method.
     * </p>
     * 
     * @return The summary information about deprecated resource usage for an insight check in the
     *         <code>UPGRADE_READINESS</code> category.
     */
    public final List<DeprecationDetail> deprecationDetails() {
        return deprecationDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddonCompatibilityDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAddonCompatibilityDetails() {
        return addonCompatibilityDetails != null && !(addonCompatibilityDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddonCompatibilityDetails} method.
     * </p>
     * 
     * @return A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
     */
    public final List<AddonCompatibilityDetail> addonCompatibilityDetails() {
        return addonCompatibilityDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDeprecationDetails() ? deprecationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddonCompatibilityDetails() ? addonCompatibilityDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightCategorySpecificSummary)) {
            return false;
        }
        InsightCategorySpecificSummary other = (InsightCategorySpecificSummary) obj;
        return hasDeprecationDetails() == other.hasDeprecationDetails()
                && Objects.equals(deprecationDetails(), other.deprecationDetails())
                && hasAddonCompatibilityDetails() == other.hasAddonCompatibilityDetails()
                && Objects.equals(addonCompatibilityDetails(), other.addonCompatibilityDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsightCategorySpecificSummary")
                .add("DeprecationDetails", hasDeprecationDetails() ? deprecationDetails() : null)
                .add("AddonCompatibilityDetails", hasAddonCompatibilityDetails() ? addonCompatibilityDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deprecationDetails":
            return Optional.ofNullable(clazz.cast(deprecationDetails()));
        case "addonCompatibilityDetails":
            return Optional.ofNullable(clazz.cast(addonCompatibilityDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deprecationDetails", DEPRECATION_DETAILS_FIELD);
        map.put("addonCompatibilityDetails", ADDON_COMPATIBILITY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InsightCategorySpecificSummary, T> g) {
        return obj -> g.apply((InsightCategorySpecificSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsightCategorySpecificSummary> {
        /**
         * <p>
         * The summary information about deprecated resource usage for an insight check in the
         * <code>UPGRADE_READINESS</code> category.
         * </p>
         * 
         * @param deprecationDetails
         *        The summary information about deprecated resource usage for an insight check in the
         *        <code>UPGRADE_READINESS</code> category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDetails(Collection<DeprecationDetail> deprecationDetails);

        /**
         * <p>
         * The summary information about deprecated resource usage for an insight check in the
         * <code>UPGRADE_READINESS</code> category.
         * </p>
         * 
         * @param deprecationDetails
         *        The summary information about deprecated resource usage for an insight check in the
         *        <code>UPGRADE_READINESS</code> category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationDetails(DeprecationDetail... deprecationDetails);

        /**
         * <p>
         * The summary information about deprecated resource usage for an insight check in the
         * <code>UPGRADE_READINESS</code> category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.DeprecationDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.eks.model.DeprecationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.DeprecationDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #deprecationDetails(List<DeprecationDetail>)}.
         * 
         * @param deprecationDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.DeprecationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deprecationDetails(java.util.Collection<DeprecationDetail>)
         */
        Builder deprecationDetails(Consumer<DeprecationDetail.Builder>... deprecationDetails);

        /**
         * <p>
         * A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
         * </p>
         * 
         * @param addonCompatibilityDetails
         *        A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonCompatibilityDetails(Collection<AddonCompatibilityDetail> addonCompatibilityDetails);

        /**
         * <p>
         * A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
         * </p>
         * 
         * @param addonCompatibilityDetails
         *        A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonCompatibilityDetails(AddonCompatibilityDetail... addonCompatibilityDetails);

        /**
         * <p>
         * A list of <code>AddonCompatibilityDetail</code> objects for Amazon EKS add-ons.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.AddonCompatibilityDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.eks.model.AddonCompatibilityDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.eks.model.AddonCompatibilityDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #addonCompatibilityDetails(List<AddonCompatibilityDetail>)}.
         * 
         * @param addonCompatibilityDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.eks.model.AddonCompatibilityDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addonCompatibilityDetails(java.util.Collection<AddonCompatibilityDetail>)
         */
        Builder addonCompatibilityDetails(Consumer<AddonCompatibilityDetail.Builder>... addonCompatibilityDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<DeprecationDetail> deprecationDetails = DefaultSdkAutoConstructList.getInstance();

        private List<AddonCompatibilityDetail> addonCompatibilityDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightCategorySpecificSummary model) {
            deprecationDetails(model.deprecationDetails);
            addonCompatibilityDetails(model.addonCompatibilityDetails);
        }

        public final List<DeprecationDetail.Builder> getDeprecationDetails() {
            List<DeprecationDetail.Builder> result = DeprecationDetailsCopier.copyToBuilder(this.deprecationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeprecationDetails(Collection<DeprecationDetail.BuilderImpl> deprecationDetails) {
            this.deprecationDetails = DeprecationDetailsCopier.copyFromBuilder(deprecationDetails);
        }

        @Override
        public final Builder deprecationDetails(Collection<DeprecationDetail> deprecationDetails) {
            this.deprecationDetails = DeprecationDetailsCopier.copy(deprecationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprecationDetails(DeprecationDetail... deprecationDetails) {
            deprecationDetails(Arrays.asList(deprecationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deprecationDetails(Consumer<DeprecationDetail.Builder>... deprecationDetails) {
            deprecationDetails(Stream.of(deprecationDetails).map(c -> DeprecationDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AddonCompatibilityDetail.Builder> getAddonCompatibilityDetails() {
            List<AddonCompatibilityDetail.Builder> result = AddonCompatibilityDetailsCopier
                    .copyToBuilder(this.addonCompatibilityDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonCompatibilityDetails(Collection<AddonCompatibilityDetail.BuilderImpl> addonCompatibilityDetails) {
            this.addonCompatibilityDetails = AddonCompatibilityDetailsCopier.copyFromBuilder(addonCompatibilityDetails);
        }

        @Override
        public final Builder addonCompatibilityDetails(Collection<AddonCompatibilityDetail> addonCompatibilityDetails) {
            this.addonCompatibilityDetails = AddonCompatibilityDetailsCopier.copy(addonCompatibilityDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonCompatibilityDetails(AddonCompatibilityDetail... addonCompatibilityDetails) {
            addonCompatibilityDetails(Arrays.asList(addonCompatibilityDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonCompatibilityDetails(Consumer<AddonCompatibilityDetail.Builder>... addonCompatibilityDetails) {
            addonCompatibilityDetails(Stream.of(addonCompatibilityDetails)
                    .map(c -> AddonCompatibilityDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InsightCategorySpecificSummary build() {
            return new InsightCategorySpecificSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
