/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Kubernetes network configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesNetworkConfigRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesNetworkConfigRequest.Builder, KubernetesNetworkConfigRequest> {
    private static final SdkField<String> SERVICE_IPV4_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIpv4Cidr").getter(getter(KubernetesNetworkConfigRequest::serviceIpv4Cidr))
            .setter(setter(Builder::serviceIpv4Cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIpv4Cidr").build()).build();

    private static final SdkField<String> IP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipFamily").getter(getter(KubernetesNetworkConfigRequest::ipFamilyAsString))
            .setter(setter(Builder::ipFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipFamily").build()).build();

    private static final SdkField<ElasticLoadBalancing> ELASTIC_LOAD_BALANCING_FIELD = SdkField
            .<ElasticLoadBalancing> builder(MarshallingType.SDK_POJO).memberName("elasticLoadBalancing")
            .getter(getter(KubernetesNetworkConfigRequest::elasticLoadBalancing)).setter(setter(Builder::elasticLoadBalancing))
            .constructor(ElasticLoadBalancing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticLoadBalancing").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IPV4_CIDR_FIELD,
            IP_FAMILY_FIELD, ELASTIC_LOAD_BALANCING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceIpv4Cidr;

    private final String ipFamily;

    private final ElasticLoadBalancing elasticLoadBalancing;

    private KubernetesNetworkConfigRequest(BuilderImpl builder) {
        this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
        this.ipFamily = builder.ipFamily;
        this.elasticLoadBalancing = builder.elasticLoadBalancing;
    }

    /**
     * <p>
     * Don't specify a value if you select <code>ipv6</code> for <b>ipFamily</b>. The CIDR block to assign Kubernetes
     * service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the
     * <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you specify a block that
     * does not overlap with resources in other networks that are peered or connected to your VPC. The block must meet
     * the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Within one of the following private IP address blocks: <code>10.0.0.0/8</code>, <code>172.16.0.0/12</code>, or
     * <code>192.168.0.0/16</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between <code>/24</code> and <code>/12</code>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * You can only specify a custom CIDR block when you create a cluster. You can't change this value after the cluster
     * is created.
     * </p>
     * </important>
     * 
     * @return Don't specify a value if you select <code>ipv6</code> for <b>ipFamily</b>. The CIDR block to assign
     *         Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from
     *         either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you
     *         specify a block that does not overlap with resources in other networks that are peered or connected to
     *         your VPC. The block must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Within one of the following private IP address blocks: <code>10.0.0.0/8</code>,
     *         <code>172.16.0.0/12</code>, or <code>192.168.0.0/16</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between <code>/24</code> and <code>/12</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         You can only specify a custom CIDR block when you create a cluster. You can't change this value after the
     *         cluster is created.
     *         </p>
     */
    public final String serviceIpv4Cidr() {
        return serviceIpv4Cidr;
    }

    /**
     * <p>
     * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a value,
     * <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and can't
     * change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and subnets that you
     * specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them.
     * You can't specify <code>ipv6</code> for clusters in China Regions.
     * </p>
     * <p>
     * You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
     * <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure that
     * your VPC meets the requirements listed in the considerations listed in <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and
     * services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code> addresses from
     * the unique local address range <code>(fc00::/7)</code>. You can't specify a custom <code>IPv6</code> CIDR block.
     * Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipFamily} will
     * return {@link IpFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipFamilyAsString}.
     * </p>
     * 
     * @return Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a
     *         value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster
     *         and can't change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and
     *         subnets that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR
     *         blocks assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.</p>
     *         <p>
     *         You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
     *         <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure
     *         that your VPC meets the requirements listed in the considerations listed in <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods
     *         and services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code>
     *         addresses from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom
     *         <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
     * @see IpFamily
     */
    public final IpFamily ipFamily() {
        return IpFamily.fromValue(ipFamily);
    }

    /**
     * <p>
     * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a value,
     * <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and can't
     * change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and subnets that you
     * specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them.
     * You can't specify <code>ipv6</code> for clusters in China Regions.
     * </p>
     * <p>
     * You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
     * <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure that
     * your VPC meets the requirements listed in the considerations listed in <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and
     * services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code> addresses from
     * the unique local address range <code>(fc00::/7)</code>. You can't specify a custom <code>IPv6</code> CIDR block.
     * Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipFamily} will
     * return {@link IpFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipFamilyAsString}.
     * </p>
     * 
     * @return Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a
     *         value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster
     *         and can't change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and
     *         subnets that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR
     *         blocks assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.</p>
     *         <p>
     *         You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
     *         <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure
     *         that your VPC meets the requirements listed in the considerations listed in <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods
     *         and services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code>
     *         addresses from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom
     *         <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
     * @see IpFamily
     */
    public final String ipFamilyAsString() {
        return ipFamily;
    }

    /**
     * <p>
     * Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more information,
     * see EKS Auto Mode load balancing capability in the <i>Amazon EKS User Guide</i>.
     * </p>
     * 
     * @return Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more
     *         information, see EKS Auto Mode load balancing capability in the <i>Amazon EKS User Guide</i>.
     */
    public final ElasticLoadBalancing elasticLoadBalancing() {
        return elasticLoadBalancing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceIpv4Cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesNetworkConfigRequest)) {
            return false;
        }
        KubernetesNetworkConfigRequest other = (KubernetesNetworkConfigRequest) obj;
        return Objects.equals(serviceIpv4Cidr(), other.serviceIpv4Cidr())
                && Objects.equals(ipFamilyAsString(), other.ipFamilyAsString())
                && Objects.equals(elasticLoadBalancing(), other.elasticLoadBalancing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesNetworkConfigRequest").add("ServiceIpv4Cidr", serviceIpv4Cidr())
                .add("IpFamily", ipFamilyAsString()).add("ElasticLoadBalancing", elasticLoadBalancing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceIpv4Cidr":
            return Optional.ofNullable(clazz.cast(serviceIpv4Cidr()));
        case "ipFamily":
            return Optional.ofNullable(clazz.cast(ipFamilyAsString()));
        case "elasticLoadBalancing":
            return Optional.ofNullable(clazz.cast(elasticLoadBalancing()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceIpv4Cidr", SERVICE_IPV4_CIDR_FIELD);
        map.put("ipFamily", IP_FAMILY_FIELD);
        map.put("elasticLoadBalancing", ELASTIC_LOAD_BALANCING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesNetworkConfigRequest, T> g) {
        return obj -> g.apply((KubernetesNetworkConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesNetworkConfigRequest> {
        /**
         * <p>
         * Don't specify a value if you select <code>ipv6</code> for <b>ipFamily</b>. The CIDR block to assign
         * Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either
         * the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you specify a
         * block that does not overlap with resources in other networks that are peered or connected to your VPC. The
         * block must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Within one of the following private IP address blocks: <code>10.0.0.0/8</code>, <code>172.16.0.0/12</code>,
         * or <code>192.168.0.0/16</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * Between <code>/24</code> and <code>/12</code>.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * You can only specify a custom CIDR block when you create a cluster. You can't change this value after the
         * cluster is created.
         * </p>
         * </important>
         * 
         * @param serviceIpv4Cidr
         *        Don't specify a value if you select <code>ipv6</code> for <b>ipFamily</b>. The CIDR block to assign
         *        Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from
         *        either the <code>10.100.0.0/16</code> or <code>172.20.0.0/16</code> CIDR blocks. We recommend that you
         *        specify a block that does not overlap with resources in other networks that are peered or connected to
         *        your VPC. The block must meet the following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Within one of the following private IP address blocks: <code>10.0.0.0/8</code>,
         *        <code>172.16.0.0/12</code>, or <code>192.168.0.0/16</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between <code>/24</code> and <code>/12</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        You can only specify a custom CIDR block when you create a cluster. You can't change this value after
         *        the cluster is created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIpv4Cidr(String serviceIpv4Cidr);

        /**
         * <p>
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a
         * value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and
         * can't change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and subnets
         * that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks
         * assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.
         * </p>
         * <p>
         * You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
         * <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure that
         * your VPC meets the requirements listed in the considerations listed in <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and
         * services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code> addresses
         * from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom <code>IPv6</code>
         * CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
         * </p>
         * 
         * @param ipFamily
         *        Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't
         *        specify a value, <code>ipv4</code> is used by default. You can only specify an IP family when you
         *        create a cluster and can't change this value once the cluster is created. If you specify
         *        <code>ipv6</code>, the VPC and subnets that you specify for cluster creation must have both
         *        <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them. You can't specify
         *        <code>ipv6</code> for clusters in China Regions.</p>
         *        <p>
         *        You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
         *        <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then
         *        ensure that your VPC meets the requirements listed in the considerations listed in <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods
         *        and services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code>
         *        addresses from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom
         *        <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
         * @see IpFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpFamily
         */
        Builder ipFamily(String ipFamily);

        /**
         * <p>
         * Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't specify a
         * value, <code>ipv4</code> is used by default. You can only specify an IP family when you create a cluster and
         * can't change this value once the cluster is created. If you specify <code>ipv6</code>, the VPC and subnets
         * that you specify for cluster creation must have both <code>IPv4</code> and <code>IPv6</code> CIDR blocks
         * assigned to them. You can't specify <code>ipv6</code> for clusters in China Regions.
         * </p>
         * <p>
         * You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
         * <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then ensure that
         * your VPC meets the requirements listed in the considerations listed in <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods and
         * services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code> addresses
         * from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom <code>IPv6</code>
         * CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
         * </p>
         * 
         * @param ipFamily
         *        Specify which IP family is used to assign Kubernetes pod and service IP addresses. If you don't
         *        specify a value, <code>ipv4</code> is used by default. You can only specify an IP family when you
         *        create a cluster and can't change this value once the cluster is created. If you specify
         *        <code>ipv6</code>, the VPC and subnets that you specify for cluster creation must have both
         *        <code>IPv4</code> and <code>IPv6</code> CIDR blocks assigned to them. You can't specify
         *        <code>ipv6</code> for clusters in China Regions.</p>
         *        <p>
         *        You can only specify <code>ipv6</code> for <code>1.21</code> and later clusters that use version
         *        <code>1.10.1</code> or later of the Amazon VPC CNI add-on. If you specify <code>ipv6</code>, then
         *        ensure that your VPC meets the requirements listed in the considerations listed in <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html">Assigning IPv6 addresses to pods
         *        and services</a> in the <i>Amazon EKS User Guide</i>. Kubernetes assigns services <code>IPv6</code>
         *        addresses from the unique local address range <code>(fc00::/7)</code>. You can't specify a custom
         *        <code>IPv6</code> CIDR block. Pod addresses are assigned from the subnet's <code>IPv6</code> CIDR.
         * @see IpFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpFamily
         */
        Builder ipFamily(IpFamily ipFamily);

        /**
         * <p>
         * Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more
         * information, see EKS Auto Mode load balancing capability in the <i>Amazon EKS User Guide</i>.
         * </p>
         * 
         * @param elasticLoadBalancing
         *        Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more
         *        information, see EKS Auto Mode load balancing capability in the <i>Amazon EKS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancing(ElasticLoadBalancing elasticLoadBalancing);

        /**
         * <p>
         * Request to enable or disable the load balancing capability on your EKS Auto Mode cluster. For more
         * information, see EKS Auto Mode load balancing capability in the <i>Amazon EKS User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElasticLoadBalancing.Builder} avoiding
         * the need to create one manually via {@link ElasticLoadBalancing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElasticLoadBalancing.Builder#build()} is called immediately and
         * its result is passed to {@link #elasticLoadBalancing(ElasticLoadBalancing)}.
         * 
         * @param elasticLoadBalancing
         *        a consumer that will call methods on {@link ElasticLoadBalancing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticLoadBalancing(ElasticLoadBalancing)
         */
        default Builder elasticLoadBalancing(Consumer<ElasticLoadBalancing.Builder> elasticLoadBalancing) {
            return elasticLoadBalancing(ElasticLoadBalancing.builder().applyMutation(elasticLoadBalancing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceIpv4Cidr;

        private String ipFamily;

        private ElasticLoadBalancing elasticLoadBalancing;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesNetworkConfigRequest model) {
            serviceIpv4Cidr(model.serviceIpv4Cidr);
            ipFamily(model.ipFamily);
            elasticLoadBalancing(model.elasticLoadBalancing);
        }

        public final String getServiceIpv4Cidr() {
            return serviceIpv4Cidr;
        }

        public final void setServiceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
        }

        @Override
        public final Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        public final String getIpFamily() {
            return ipFamily;
        }

        public final void setIpFamily(String ipFamily) {
            this.ipFamily = ipFamily;
        }

        @Override
        public final Builder ipFamily(String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        @Override
        public final Builder ipFamily(IpFamily ipFamily) {
            this.ipFamily(ipFamily == null ? null : ipFamily.toString());
            return this;
        }

        public final ElasticLoadBalancing.Builder getElasticLoadBalancing() {
            return elasticLoadBalancing != null ? elasticLoadBalancing.toBuilder() : null;
        }

        public final void setElasticLoadBalancing(ElasticLoadBalancing.BuilderImpl elasticLoadBalancing) {
            this.elasticLoadBalancing = elasticLoadBalancing != null ? elasticLoadBalancing.build() : null;
        }

        @Override
        public final Builder elasticLoadBalancing(ElasticLoadBalancing elasticLoadBalancing) {
            this.elasticLoadBalancing = elasticLoadBalancing;
            return this;
        }

        @Override
        public KubernetesNetworkConfigRequest build() {
            return new KubernetesNetworkConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
