/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon EKS managed node group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Nodegroup implements SdkPojo, Serializable, ToCopyableBuilder<Nodegroup.Builder, Nodegroup> {
    private static final SdkField<String> NODEGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupName").getter(getter(Nodegroup::nodegroupName)).setter(setter(Builder::nodegroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupName").build()).build();

    private static final SdkField<String> NODEGROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodegroupArn").getter(getter(Nodegroup::nodegroupArn)).setter(setter(Builder::nodegroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodegroupArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(Nodegroup::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Nodegroup::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> RELEASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseVersion").getter(getter(Nodegroup::releaseVersion)).setter(setter(Builder::releaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Nodegroup::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt").getter(getter(Nodegroup::modifiedAt)).setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Nodegroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityType").getter(getter(Nodegroup::capacityTypeAsString)).setter(setter(Builder::capacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityType").build()).build();

    private static final SdkField<NodegroupScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<NodegroupScalingConfig> builder(MarshallingType.SDK_POJO).memberName("scalingConfig")
            .getter(getter(Nodegroup::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(NodegroupScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfig").build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceTypes")
            .getter(getter(Nodegroup::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(Nodegroup::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RemoteAccessConfig> REMOTE_ACCESS_FIELD = SdkField
            .<RemoteAccessConfig> builder(MarshallingType.SDK_POJO).memberName("remoteAccess")
            .getter(getter(Nodegroup::remoteAccess)).setter(setter(Builder::remoteAccess))
            .constructor(RemoteAccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccess").build()).build();

    private static final SdkField<String> AMI_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amiType").getter(getter(Nodegroup::amiTypeAsString)).setter(setter(Builder::amiType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiType").build()).build();

    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeRole").getter(getter(Nodegroup::nodeRole)).setter(setter(Builder::nodeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRole").build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labels")
            .getter(getter(Nodegroup::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Taint>> TAINTS_FIELD = SdkField
            .<List<Taint>> builder(MarshallingType.LIST)
            .memberName("taints")
            .getter(getter(Nodegroup::taints))
            .setter(setter(Builder::taints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Taint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Taint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NodegroupResources> RESOURCES_FIELD = SdkField
            .<NodegroupResources> builder(MarshallingType.SDK_POJO).memberName("resources").getter(getter(Nodegroup::resources))
            .setter(setter(Builder::resources)).constructor(NodegroupResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build()).build();

    private static final SdkField<Integer> DISK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("diskSize").getter(getter(Nodegroup::diskSize)).setter(setter(Builder::diskSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSize").build()).build();

    private static final SdkField<NodegroupHealth> HEALTH_FIELD = SdkField.<NodegroupHealth> builder(MarshallingType.SDK_POJO)
            .memberName("health").getter(getter(Nodegroup::health)).setter(setter(Builder::health))
            .constructor(NodegroupHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final SdkField<NodegroupUpdateConfig> UPDATE_CONFIG_FIELD = SdkField
            .<NodegroupUpdateConfig> builder(MarshallingType.SDK_POJO).memberName("updateConfig")
            .getter(getter(Nodegroup::updateConfig)).setter(setter(Builder::updateConfig))
            .constructor(NodegroupUpdateConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfig").build()).build();

    private static final SdkField<NodeRepairConfig> NODE_REPAIR_CONFIG_FIELD = SdkField
            .<NodeRepairConfig> builder(MarshallingType.SDK_POJO).memberName("nodeRepairConfig")
            .getter(getter(Nodegroup::nodeRepairConfig)).setter(setter(Builder::nodeRepairConfig))
            .constructor(NodeRepairConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRepairConfig").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("launchTemplate")
            .getter(getter(Nodegroup::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Nodegroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODEGROUP_NAME_FIELD,
            NODEGROUP_ARN_FIELD, CLUSTER_NAME_FIELD, VERSION_FIELD, RELEASE_VERSION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD,
            STATUS_FIELD, CAPACITY_TYPE_FIELD, SCALING_CONFIG_FIELD, INSTANCE_TYPES_FIELD, SUBNETS_FIELD, REMOTE_ACCESS_FIELD,
            AMI_TYPE_FIELD, NODE_ROLE_FIELD, LABELS_FIELD, TAINTS_FIELD, RESOURCES_FIELD, DISK_SIZE_FIELD, HEALTH_FIELD,
            UPDATE_CONFIG_FIELD, NODE_REPAIR_CONFIG_FIELD, LAUNCH_TEMPLATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodegroupName;

    private final String nodegroupArn;

    private final String clusterName;

    private final String version;

    private final String releaseVersion;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private final String status;

    private final String capacityType;

    private final NodegroupScalingConfig scalingConfig;

    private final List<String> instanceTypes;

    private final List<String> subnets;

    private final RemoteAccessConfig remoteAccess;

    private final String amiType;

    private final String nodeRole;

    private final Map<String, String> labels;

    private final List<Taint> taints;

    private final NodegroupResources resources;

    private final Integer diskSize;

    private final NodegroupHealth health;

    private final NodegroupUpdateConfig updateConfig;

    private final NodeRepairConfig nodeRepairConfig;

    private final LaunchTemplateSpecification launchTemplate;

    private final Map<String, String> tags;

    private Nodegroup(BuilderImpl builder) {
        this.nodegroupName = builder.nodegroupName;
        this.nodegroupArn = builder.nodegroupArn;
        this.clusterName = builder.clusterName;
        this.version = builder.version;
        this.releaseVersion = builder.releaseVersion;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.status = builder.status;
        this.capacityType = builder.capacityType;
        this.scalingConfig = builder.scalingConfig;
        this.instanceTypes = builder.instanceTypes;
        this.subnets = builder.subnets;
        this.remoteAccess = builder.remoteAccess;
        this.amiType = builder.amiType;
        this.nodeRole = builder.nodeRole;
        this.labels = builder.labels;
        this.taints = builder.taints;
        this.resources = builder.resources;
        this.diskSize = builder.diskSize;
        this.health = builder.health;
        this.updateConfig = builder.updateConfig;
        this.nodeRepairConfig = builder.nodeRepairConfig;
        this.launchTemplate = builder.launchTemplate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name associated with an Amazon EKS managed node group.
     * </p>
     * 
     * @return The name associated with an Amazon EKS managed node group.
     */
    public final String nodegroupName() {
        return nodegroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the managed node group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the managed node group.
     */
    public final String nodegroupArn() {
        return nodegroupArn;
    }

    /**
     * <p>
     * The name of your cluster.
     * </p>
     * 
     * @return The name of your cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The Kubernetes version of the managed node group.
     * </p>
     * 
     * @return The Kubernetes version of the managed node group.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that was
     * specified in the launch template. For node groups that weren't deployed using a launch template, this is the
     * version of the Amazon EKS optimized AMI that the node group was deployed with.
     * </p>
     * 
     * @return If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that
     *         was specified in the launch template. For node groups that weren't deployed using a launch template, this
     *         is the version of the Amazon EKS optimized AMI that the node group was deployed with.
     */
    public final String releaseVersion() {
        return releaseVersion;
    }

    /**
     * <p>
     * The Unix epoch timestamp at object creation.
     * </p>
     * 
     * @return The Unix epoch timestamp at object creation.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Unix epoch timestamp for the last modification to the object.
     * </p>
     * 
     * @return The Unix epoch timestamp for the last modification to the object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * <p>
     * The current status of the managed node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodegroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the managed node group.
     * @see NodegroupStatus
     */
    public final NodegroupStatus status() {
        return NodegroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the managed node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodegroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the managed node group.
     * @see NodegroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The capacity type of your managed node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #capacityType} will
     * return {@link CapacityTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #capacityTypeAsString}.
     * </p>
     * 
     * @return The capacity type of your managed node group.
     * @see CapacityTypes
     */
    public final CapacityTypes capacityType() {
        return CapacityTypes.fromValue(capacityType);
    }

    /**
     * <p>
     * The capacity type of your managed node group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #capacityType} will
     * return {@link CapacityTypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #capacityTypeAsString}.
     * </p>
     * 
     * @return The capacity type of your managed node group.
     * @see CapacityTypes
     */
    public final String capacityTypeAsString() {
        return capacityType;
    }

    /**
     * <p>
     * The scaling configuration details for the Auto Scaling group that is associated with your node group.
     * </p>
     * 
     * @return The scaling configuration details for the Auto Scaling group that is associated with your node group.
     */
    public final NodegroupScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the node group wasn't deployed with a launch template, then this is the instance type that is associated with
     * the node group. If the node group was deployed with a launch template, then this is <code>null</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypes} method.
     * </p>
     * 
     * @return If the node group wasn't deployed with a launch template, then this is the instance type that is
     *         associated with the node group. If the node group was deployed with a launch template, then this is
     *         <code>null</code>.
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets that were specified for the Auto Scaling group that is associated with your node group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The subnets that were specified for the Auto Scaling group that is associated with your node group.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * <p>
     * If the node group wasn't deployed with a launch template, then this is the remote access configuration that is
     * associated with the node group. If the node group was deployed with a launch template, then this is
     * <code>null</code>.
     * </p>
     * 
     * @return If the node group wasn't deployed with a launch template, then this is the remote access configuration
     *         that is associated with the node group. If the node group was deployed with a launch template, then this
     *         is <code>null</code>.
     */
    public final RemoteAccessConfig remoteAccess() {
        return remoteAccess;
    }

    /**
     * <p>
     * If the node group was deployed using a launch template with a custom AMI, then this is <code>CUSTOM</code>. For
     * node groups that weren't deployed using a launch template, this is the AMI type that was specified in the node
     * group configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amiType} will
     * return {@link AMITypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amiTypeAsString}.
     * </p>
     * 
     * @return If the node group was deployed using a launch template with a custom AMI, then this is
     *         <code>CUSTOM</code>. For node groups that weren't deployed using a launch template, this is the AMI type
     *         that was specified in the node group configuration.
     * @see AMITypes
     */
    public final AMITypes amiType() {
        return AMITypes.fromValue(amiType);
    }

    /**
     * <p>
     * If the node group was deployed using a launch template with a custom AMI, then this is <code>CUSTOM</code>. For
     * node groups that weren't deployed using a launch template, this is the AMI type that was specified in the node
     * group configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amiType} will
     * return {@link AMITypes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amiTypeAsString}.
     * </p>
     * 
     * @return If the node group was deployed using a launch template with a custom AMI, then this is
     *         <code>CUSTOM</code>. For node groups that weren't deployed using a launch template, this is the AMI type
     *         that was specified in the node group configuration.
     * @see AMITypes
     */
    public final String amiTypeAsString() {
        return amiType;
    }

    /**
     * <p>
     * The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code> daemon makes calls to
     * Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance
     * profile and associated policies.
     * </p>
     * 
     * @return The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code> daemon makes calls
     *         to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM
     *         instance profile and associated policies.
     */
    public final String nodeRole() {
        return nodeRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Kubernetes <code>labels</code> applied to the nodes in the node group.
     * </p>
     * <note>
     * <p>
     * Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other Kubernetes
     * <code>labels</code> applied to the nodes in this group.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return The Kubernetes <code>labels</code> applied to the nodes in the node group.</p> <note>
     *         <p>
     *         Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other
     *         Kubernetes <code>labels</code> applied to the nodes in this group.
     *         </p>
     */
    public final Map<String, String> labels() {
        return labels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Taints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaints() {
        return taints != null && !(taints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of
     * <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints can be
     * used together with tolerations to control how workloads are scheduled to your nodes. For more information, see <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints on
     * managed node groups</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaints} method.
     * </p>
     * 
     * @return The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one
     *         of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes
     *         taints can be used together with tolerations to control how workloads are scheduled to your nodes. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node taints
     *         on managed node groups</a>.
     */
    public final List<Taint> taints() {
        return taints;
    }

    /**
     * <p>
     * The resources associated with the node group, such as Auto Scaling groups and security groups for remote access.
     * </p>
     * 
     * @return The resources associated with the node group, such as Auto Scaling groups and security groups for remote
     *         access.
     */
    public final NodegroupResources resources() {
        return resources;
    }

    /**
     * <p>
     * If the node group wasn't deployed with a launch template, then this is the disk size in the node group
     * configuration. If the node group was deployed with a launch template, then this is <code>null</code>.
     * </p>
     * 
     * @return If the node group wasn't deployed with a launch template, then this is the disk size in the node group
     *         configuration. If the node group was deployed with a launch template, then this is <code>null</code>.
     */
    public final Integer diskSize() {
        return diskSize;
    }

    /**
     * <p>
     * The health status of the node group. If there are issues with your node group's health, they are listed here.
     * </p>
     * 
     * @return The health status of the node group. If there are issues with your node group's health, they are listed
     *         here.
     */
    public final NodegroupHealth health() {
        return health;
    }

    /**
     * <p>
     * The node group update configuration.
     * </p>
     * 
     * @return The node group update configuration.
     */
    public final NodegroupUpdateConfig updateConfig() {
        return updateConfig;
    }

    /**
     * <p>
     * The node auto repair configuration for the node group.
     * </p>
     * 
     * @return The node auto repair configuration for the node group.
     */
    public final NodeRepairConfig nodeRepairConfig() {
        return nodeRepairConfig;
    }

    /**
     * <p>
     * If a launch template was used to create the node group, then this is the launch template that was used.
     * </p>
     * 
     * @return If a launch template was used to create the node group, then this is the launch template that was used.
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value. You
     * define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that assists with categorization and organization. Each tag consists of a key and an optional
     *         value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupName());
        hashCode = 31 * hashCode + Objects.hashCode(nodegroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(releaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccess());
        hashCode = 31 * hashCode + Objects.hashCode(amiTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaints() ? taints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(diskSize());
        hashCode = 31 * hashCode + Objects.hashCode(health());
        hashCode = 31 * hashCode + Objects.hashCode(updateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRepairConfig());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nodegroup)) {
            return false;
        }
        Nodegroup other = (Nodegroup) obj;
        return Objects.equals(nodegroupName(), other.nodegroupName()) && Objects.equals(nodegroupArn(), other.nodegroupArn())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(version(), other.version())
                && Objects.equals(releaseVersion(), other.releaseVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(capacityTypeAsString(), other.capacityTypeAsString())
                && Objects.equals(scalingConfig(), other.scalingConfig()) && hasInstanceTypes() == other.hasInstanceTypes()
                && Objects.equals(instanceTypes(), other.instanceTypes()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && Objects.equals(remoteAccess(), other.remoteAccess())
                && Objects.equals(amiTypeAsString(), other.amiTypeAsString()) && Objects.equals(nodeRole(), other.nodeRole())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && hasTaints() == other.hasTaints() && Objects.equals(taints(), other.taints())
                && Objects.equals(resources(), other.resources()) && Objects.equals(diskSize(), other.diskSize())
                && Objects.equals(health(), other.health()) && Objects.equals(updateConfig(), other.updateConfig())
                && Objects.equals(nodeRepairConfig(), other.nodeRepairConfig())
                && Objects.equals(launchTemplate(), other.launchTemplate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Nodegroup").add("NodegroupName", nodegroupName()).add("NodegroupArn", nodegroupArn())
                .add("ClusterName", clusterName()).add("Version", version()).add("ReleaseVersion", releaseVersion())
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).add("Status", statusAsString())
                .add("CapacityType", capacityTypeAsString()).add("ScalingConfig", scalingConfig())
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null)
                .add("Subnets", hasSubnets() ? subnets() : null).add("RemoteAccess", remoteAccess())
                .add("AmiType", amiTypeAsString()).add("NodeRole", nodeRole()).add("Labels", hasLabels() ? labels() : null)
                .add("Taints", hasTaints() ? taints() : null).add("Resources", resources()).add("DiskSize", diskSize())
                .add("Health", health()).add("UpdateConfig", updateConfig()).add("NodeRepairConfig", nodeRepairConfig())
                .add("LaunchTemplate", launchTemplate()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodegroupName":
            return Optional.ofNullable(clazz.cast(nodegroupName()));
        case "nodegroupArn":
            return Optional.ofNullable(clazz.cast(nodegroupArn()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "releaseVersion":
            return Optional.ofNullable(clazz.cast(releaseVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "capacityType":
            return Optional.ofNullable(clazz.cast(capacityTypeAsString()));
        case "scalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "remoteAccess":
            return Optional.ofNullable(clazz.cast(remoteAccess()));
        case "amiType":
            return Optional.ofNullable(clazz.cast(amiTypeAsString()));
        case "nodeRole":
            return Optional.ofNullable(clazz.cast(nodeRole()));
        case "labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "taints":
            return Optional.ofNullable(clazz.cast(taints()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "diskSize":
            return Optional.ofNullable(clazz.cast(diskSize()));
        case "health":
            return Optional.ofNullable(clazz.cast(health()));
        case "updateConfig":
            return Optional.ofNullable(clazz.cast(updateConfig()));
        case "nodeRepairConfig":
            return Optional.ofNullable(clazz.cast(nodeRepairConfig()));
        case "launchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodegroupName", NODEGROUP_NAME_FIELD);
        map.put("nodegroupArn", NODEGROUP_ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("releaseVersion", RELEASE_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capacityType", CAPACITY_TYPE_FIELD);
        map.put("scalingConfig", SCALING_CONFIG_FIELD);
        map.put("instanceTypes", INSTANCE_TYPES_FIELD);
        map.put("subnets", SUBNETS_FIELD);
        map.put("remoteAccess", REMOTE_ACCESS_FIELD);
        map.put("amiType", AMI_TYPE_FIELD);
        map.put("nodeRole", NODE_ROLE_FIELD);
        map.put("labels", LABELS_FIELD);
        map.put("taints", TAINTS_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("diskSize", DISK_SIZE_FIELD);
        map.put("health", HEALTH_FIELD);
        map.put("updateConfig", UPDATE_CONFIG_FIELD);
        map.put("nodeRepairConfig", NODE_REPAIR_CONFIG_FIELD);
        map.put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Nodegroup, T> g) {
        return obj -> g.apply((Nodegroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Nodegroup> {
        /**
         * <p>
         * The name associated with an Amazon EKS managed node group.
         * </p>
         * 
         * @param nodegroupName
         *        The name associated with an Amazon EKS managed node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupName(String nodegroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the managed node group.
         * </p>
         * 
         * @param nodegroupArn
         *        The Amazon Resource Name (ARN) associated with the managed node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodegroupArn(String nodegroupArn);

        /**
         * <p>
         * The name of your cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The Kubernetes version of the managed node group.
         * </p>
         * 
         * @param version
         *        The Kubernetes version of the managed node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that was
         * specified in the launch template. For node groups that weren't deployed using a launch template, this is the
         * version of the Amazon EKS optimized AMI that the node group was deployed with.
         * </p>
         * 
         * @param releaseVersion
         *        If the node group was deployed using a launch template with a custom AMI, then this is the AMI ID that
         *        was specified in the launch template. For node groups that weren't deployed using a launch template,
         *        this is the version of the Amazon EKS optimized AMI that the node group was deployed with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseVersion(String releaseVersion);

        /**
         * <p>
         * The Unix epoch timestamp at object creation.
         * </p>
         * 
         * @param createdAt
         *        The Unix epoch timestamp at object creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Unix epoch timestamp for the last modification to the object.
         * </p>
         * 
         * @param modifiedAt
         *        The Unix epoch timestamp for the last modification to the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * <p>
         * The current status of the managed node group.
         * </p>
         * 
         * @param status
         *        The current status of the managed node group.
         * @see NodegroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodegroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the managed node group.
         * </p>
         * 
         * @param status
         *        The current status of the managed node group.
         * @see NodegroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodegroupStatus
         */
        Builder status(NodegroupStatus status);

        /**
         * <p>
         * The capacity type of your managed node group.
         * </p>
         * 
         * @param capacityType
         *        The capacity type of your managed node group.
         * @see CapacityTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTypes
         */
        Builder capacityType(String capacityType);

        /**
         * <p>
         * The capacity type of your managed node group.
         * </p>
         * 
         * @param capacityType
         *        The capacity type of your managed node group.
         * @see CapacityTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityTypes
         */
        Builder capacityType(CapacityTypes capacityType);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group that is associated with your node group.
         * </p>
         * 
         * @param scalingConfig
         *        The scaling configuration details for the Auto Scaling group that is associated with your node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(NodegroupScalingConfig scalingConfig);

        /**
         * <p>
         * The scaling configuration details for the Auto Scaling group that is associated with your node group.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupScalingConfig.Builder} avoiding
         * the need to create one manually via {@link NodegroupScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupScalingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #scalingConfig(NodegroupScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link NodegroupScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(NodegroupScalingConfig)
         */
        default Builder scalingConfig(Consumer<NodegroupScalingConfig.Builder> scalingConfig) {
            return scalingConfig(NodegroupScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * <p>
         * If the node group wasn't deployed with a launch template, then this is the instance type that is associated
         * with the node group. If the node group was deployed with a launch template, then this is <code>null</code>.
         * </p>
         * 
         * @param instanceTypes
         *        If the node group wasn't deployed with a launch template, then this is the instance type that is
         *        associated with the node group. If the node group was deployed with a launch template, then this is
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * If the node group wasn't deployed with a launch template, then this is the instance type that is associated
         * with the node group. If the node group was deployed with a launch template, then this is <code>null</code>.
         * </p>
         * 
         * @param instanceTypes
         *        If the node group wasn't deployed with a launch template, then this is the instance type that is
         *        associated with the node group. If the node group was deployed with a launch template, then this is
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The subnets that were specified for the Auto Scaling group that is associated with your node group.
         * </p>
         * 
         * @param subnets
         *        The subnets that were specified for the Auto Scaling group that is associated with your node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The subnets that were specified for the Auto Scaling group that is associated with your node group.
         * </p>
         * 
         * @param subnets
         *        The subnets that were specified for the Auto Scaling group that is associated with your node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * If the node group wasn't deployed with a launch template, then this is the remote access configuration that
         * is associated with the node group. If the node group was deployed with a launch template, then this is
         * <code>null</code>.
         * </p>
         * 
         * @param remoteAccess
         *        If the node group wasn't deployed with a launch template, then this is the remote access configuration
         *        that is associated with the node group. If the node group was deployed with a launch template, then
         *        this is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccess(RemoteAccessConfig remoteAccess);

        /**
         * <p>
         * If the node group wasn't deployed with a launch template, then this is the remote access configuration that
         * is associated with the node group. If the node group was deployed with a launch template, then this is
         * <code>null</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemoteAccessConfig.Builder} avoiding the
         * need to create one manually via {@link RemoteAccessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoteAccessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #remoteAccess(RemoteAccessConfig)}.
         * 
         * @param remoteAccess
         *        a consumer that will call methods on {@link RemoteAccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteAccess(RemoteAccessConfig)
         */
        default Builder remoteAccess(Consumer<RemoteAccessConfig.Builder> remoteAccess) {
            return remoteAccess(RemoteAccessConfig.builder().applyMutation(remoteAccess).build());
        }

        /**
         * <p>
         * If the node group was deployed using a launch template with a custom AMI, then this is <code>CUSTOM</code>.
         * For node groups that weren't deployed using a launch template, this is the AMI type that was specified in the
         * node group configuration.
         * </p>
         * 
         * @param amiType
         *        If the node group was deployed using a launch template with a custom AMI, then this is
         *        <code>CUSTOM</code>. For node groups that weren't deployed using a launch template, this is the AMI
         *        type that was specified in the node group configuration.
         * @see AMITypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AMITypes
         */
        Builder amiType(String amiType);

        /**
         * <p>
         * If the node group was deployed using a launch template with a custom AMI, then this is <code>CUSTOM</code>.
         * For node groups that weren't deployed using a launch template, this is the AMI type that was specified in the
         * node group configuration.
         * </p>
         * 
         * @param amiType
         *        If the node group was deployed using a launch template with a custom AMI, then this is
         *        <code>CUSTOM</code>. For node groups that weren't deployed using a launch template, this is the AMI
         *        type that was specified in the node group configuration.
         * @see AMITypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AMITypes
         */
        Builder amiType(AMITypes amiType);

        /**
         * <p>
         * The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code> daemon makes calls to
         * Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM
         * instance profile and associated policies.
         * </p>
         * 
         * @param nodeRole
         *        The IAM role associated with your node group. The Amazon EKS node <code>kubelet</code> daemon makes
         *        calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls
         *        through an IAM instance profile and associated policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRole(String nodeRole);

        /**
         * <p>
         * The Kubernetes <code>labels</code> applied to the nodes in the node group.
         * </p>
         * <note>
         * <p>
         * Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other
         * Kubernetes <code>labels</code> applied to the nodes in this group.
         * </p>
         * </note>
         * 
         * @param labels
         *        The Kubernetes <code>labels</code> applied to the nodes in the node group.</p> <note>
         *        <p>
         *        Only <code>labels</code> that are applied with the Amazon EKS API are shown here. There may be other
         *        Kubernetes <code>labels</code> applied to the nodes in this group.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of
         * <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints can
         * be used together with tolerations to control how workloads are scheduled to your nodes. For more information,
         * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         * taints on managed node groups</a>.
         * </p>
         * 
         * @param taints
         *        The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is
         *        one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>.
         *        Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your
         *        nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         *        taints on managed node groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taints(Collection<Taint> taints);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of
         * <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints can
         * be used together with tolerations to control how workloads are scheduled to your nodes. For more information,
         * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         * taints on managed node groups</a>.
         * </p>
         * 
         * @param taints
         *        The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is
         *        one of <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>.
         *        Kubernetes taints can be used together with tolerations to control how workloads are scheduled to your
         *        nodes. For more information, see <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         *        taints on managed node groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taints(Taint... taints);

        /**
         * <p>
         * The Kubernetes taints to be applied to the nodes in the node group when they are created. Effect is one of
         * <code>No_Schedule</code>, <code>Prefer_No_Schedule</code>, or <code>No_Execute</code>. Kubernetes taints can
         * be used together with tolerations to control how workloads are scheduled to your nodes. For more information,
         * see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">Node
         * taints on managed node groups</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.eks.model.Taint.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.eks.model.Taint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.eks.model.Taint.Builder#build()}
         * is called immediately and its result is passed to {@link #taints(List<Taint>)}.
         * 
         * @param taints
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.eks.model.Taint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taints(java.util.Collection<Taint>)
         */
        Builder taints(Consumer<Taint.Builder>... taints);

        /**
         * <p>
         * The resources associated with the node group, such as Auto Scaling groups and security groups for remote
         * access.
         * </p>
         * 
         * @param resources
         *        The resources associated with the node group, such as Auto Scaling groups and security groups for
         *        remote access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(NodegroupResources resources);

        /**
         * <p>
         * The resources associated with the node group, such as Auto Scaling groups and security groups for remote
         * access.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupResources.Builder} avoiding the
         * need to create one manually via {@link NodegroupResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupResources.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(NodegroupResources)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link NodegroupResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(NodegroupResources)
         */
        default Builder resources(Consumer<NodegroupResources.Builder> resources) {
            return resources(NodegroupResources.builder().applyMutation(resources).build());
        }

        /**
         * <p>
         * If the node group wasn't deployed with a launch template, then this is the disk size in the node group
         * configuration. If the node group was deployed with a launch template, then this is <code>null</code>.
         * </p>
         * 
         * @param diskSize
         *        If the node group wasn't deployed with a launch template, then this is the disk size in the node group
         *        configuration. If the node group was deployed with a launch template, then this is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSize(Integer diskSize);

        /**
         * <p>
         * The health status of the node group. If there are issues with your node group's health, they are listed here.
         * </p>
         * 
         * @param health
         *        The health status of the node group. If there are issues with your node group's health, they are
         *        listed here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder health(NodegroupHealth health);

        /**
         * <p>
         * The health status of the node group. If there are issues with your node group's health, they are listed here.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupHealth.Builder} avoiding the
         * need to create one manually via {@link NodegroupHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #health(NodegroupHealth)}.
         * 
         * @param health
         *        a consumer that will call methods on {@link NodegroupHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #health(NodegroupHealth)
         */
        default Builder health(Consumer<NodegroupHealth.Builder> health) {
            return health(NodegroupHealth.builder().applyMutation(health).build());
        }

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * 
         * @param updateConfig
         *        The node group update configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateConfig(NodegroupUpdateConfig updateConfig);

        /**
         * <p>
         * The node group update configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodegroupUpdateConfig.Builder} avoiding
         * the need to create one manually via {@link NodegroupUpdateConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodegroupUpdateConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #updateConfig(NodegroupUpdateConfig)}.
         * 
         * @param updateConfig
         *        a consumer that will call methods on {@link NodegroupUpdateConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateConfig(NodegroupUpdateConfig)
         */
        default Builder updateConfig(Consumer<NodegroupUpdateConfig.Builder> updateConfig) {
            return updateConfig(NodegroupUpdateConfig.builder().applyMutation(updateConfig).build());
        }

        /**
         * <p>
         * The node auto repair configuration for the node group.
         * </p>
         * 
         * @param nodeRepairConfig
         *        The node auto repair configuration for the node group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRepairConfig(NodeRepairConfig nodeRepairConfig);

        /**
         * <p>
         * The node auto repair configuration for the node group.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeRepairConfig.Builder} avoiding the
         * need to create one manually via {@link NodeRepairConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeRepairConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeRepairConfig(NodeRepairConfig)}.
         * 
         * @param nodeRepairConfig
         *        a consumer that will call methods on {@link NodeRepairConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeRepairConfig(NodeRepairConfig)
         */
        default Builder nodeRepairConfig(Consumer<NodeRepairConfig.Builder> nodeRepairConfig) {
            return nodeRepairConfig(NodeRepairConfig.builder().applyMutation(nodeRepairConfig).build());
        }

        /**
         * <p>
         * If a launch template was used to create the node group, then this is the launch template that was used.
         * </p>
         * 
         * @param launchTemplate
         *        If a launch template was used to create the node group, then this is the launch template that was
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * If a launch template was used to create the node group, then this is the launch template that was used.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Metadata that assists with categorization and organization. Each tag consists of a key and an optional value.
         * You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        Metadata that assists with categorization and organization. Each tag consists of a key and an optional
         *        value. You define both. Tags don't propagate to any other cluster or Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String nodegroupName;

        private String nodegroupArn;

        private String clusterName;

        private String version;

        private String releaseVersion;

        private Instant createdAt;

        private Instant modifiedAt;

        private String status;

        private String capacityType;

        private NodegroupScalingConfig scalingConfig;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private RemoteAccessConfig remoteAccess;

        private String amiType;

        private String nodeRole;

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private List<Taint> taints = DefaultSdkAutoConstructList.getInstance();

        private NodegroupResources resources;

        private Integer diskSize;

        private NodegroupHealth health;

        private NodegroupUpdateConfig updateConfig;

        private NodeRepairConfig nodeRepairConfig;

        private LaunchTemplateSpecification launchTemplate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Nodegroup model) {
            nodegroupName(model.nodegroupName);
            nodegroupArn(model.nodegroupArn);
            clusterName(model.clusterName);
            version(model.version);
            releaseVersion(model.releaseVersion);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
            status(model.status);
            capacityType(model.capacityType);
            scalingConfig(model.scalingConfig);
            instanceTypes(model.instanceTypes);
            subnets(model.subnets);
            remoteAccess(model.remoteAccess);
            amiType(model.amiType);
            nodeRole(model.nodeRole);
            labels(model.labels);
            taints(model.taints);
            resources(model.resources);
            diskSize(model.diskSize);
            health(model.health);
            updateConfig(model.updateConfig);
            nodeRepairConfig(model.nodeRepairConfig);
            launchTemplate(model.launchTemplate);
            tags(model.tags);
        }

        public final String getNodegroupName() {
            return nodegroupName;
        }

        public final void setNodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
        }

        @Override
        public final Builder nodegroupName(String nodegroupName) {
            this.nodegroupName = nodegroupName;
            return this;
        }

        public final String getNodegroupArn() {
            return nodegroupArn;
        }

        public final void setNodegroupArn(String nodegroupArn) {
            this.nodegroupArn = nodegroupArn;
        }

        @Override
        public final Builder nodegroupArn(String nodegroupArn) {
            this.nodegroupArn = nodegroupArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getReleaseVersion() {
            return releaseVersion;
        }

        public final void setReleaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
        }

        @Override
        public final Builder releaseVersion(String releaseVersion) {
            this.releaseVersion = releaseVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodegroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCapacityType() {
            return capacityType;
        }

        public final void setCapacityType(String capacityType) {
            this.capacityType = capacityType;
        }

        @Override
        public final Builder capacityType(String capacityType) {
            this.capacityType = capacityType;
            return this;
        }

        @Override
        public final Builder capacityType(CapacityTypes capacityType) {
            this.capacityType(capacityType == null ? null : capacityType.toString());
            return this;
        }

        public final NodegroupScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(NodegroupScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(NodegroupScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final RemoteAccessConfig.Builder getRemoteAccess() {
            return remoteAccess != null ? remoteAccess.toBuilder() : null;
        }

        public final void setRemoteAccess(RemoteAccessConfig.BuilderImpl remoteAccess) {
            this.remoteAccess = remoteAccess != null ? remoteAccess.build() : null;
        }

        @Override
        public final Builder remoteAccess(RemoteAccessConfig remoteAccess) {
            this.remoteAccess = remoteAccess;
            return this;
        }

        public final String getAmiType() {
            return amiType;
        }

        public final void setAmiType(String amiType) {
            this.amiType = amiType;
        }

        @Override
        public final Builder amiType(String amiType) {
            this.amiType = amiType;
            return this;
        }

        @Override
        public final Builder amiType(AMITypes amiType) {
            this.amiType(amiType == null ? null : amiType.toString());
            return this;
        }

        public final String getNodeRole() {
            return nodeRole;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = _labelsMapCopier.copy(labels);
            return this;
        }

        public final List<Taint.Builder> getTaints() {
            List<Taint.Builder> result = _taintsListCopier.copyToBuilder(this.taints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaints(Collection<Taint.BuilderImpl> taints) {
            this.taints = _taintsListCopier.copyFromBuilder(taints);
        }

        @Override
        public final Builder taints(Collection<Taint> taints) {
            this.taints = _taintsListCopier.copy(taints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Taint... taints) {
            taints(Arrays.asList(taints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taints(Consumer<Taint.Builder>... taints) {
            taints(Stream.of(taints).map(c -> Taint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final NodegroupResources.Builder getResources() {
            return resources != null ? resources.toBuilder() : null;
        }

        public final void setResources(NodegroupResources.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        @Override
        public final Builder resources(NodegroupResources resources) {
            this.resources = resources;
            return this;
        }

        public final Integer getDiskSize() {
            return diskSize;
        }

        public final void setDiskSize(Integer diskSize) {
            this.diskSize = diskSize;
        }

        @Override
        public final Builder diskSize(Integer diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public final NodegroupHealth.Builder getHealth() {
            return health != null ? health.toBuilder() : null;
        }

        public final void setHealth(NodegroupHealth.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(NodegroupHealth health) {
            this.health = health;
            return this;
        }

        public final NodegroupUpdateConfig.Builder getUpdateConfig() {
            return updateConfig != null ? updateConfig.toBuilder() : null;
        }

        public final void setUpdateConfig(NodegroupUpdateConfig.BuilderImpl updateConfig) {
            this.updateConfig = updateConfig != null ? updateConfig.build() : null;
        }

        @Override
        public final Builder updateConfig(NodegroupUpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        public final NodeRepairConfig.Builder getNodeRepairConfig() {
            return nodeRepairConfig != null ? nodeRepairConfig.toBuilder() : null;
        }

        public final void setNodeRepairConfig(NodeRepairConfig.BuilderImpl nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig != null ? nodeRepairConfig.build() : null;
        }

        @Override
        public final Builder nodeRepairConfig(NodeRepairConfig nodeRepairConfig) {
            this.nodeRepairConfig = nodeRepairConfig;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Nodegroup build() {
            return new Nodegroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
