/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddonCompatibilityDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddonCompatibilityDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AddonCompatibilityDetail.getter(AddonCompatibilityDetail::name)).setter(AddonCompatibilityDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compatibleVersions").getter(AddonCompatibilityDetail.getter(AddonCompatibilityDetail::compatibleVersions)).setter(AddonCompatibilityDetail.setter(Builder::compatibleVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COMPATIBLE_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddonCompatibilityDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> compatibleVersions;

    private AddonCompatibilityDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.compatibleVersions = builder.compatibleVersions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasCompatibleVersions() {
        return this.compatibleVersions != null && !(this.compatibleVersions instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleVersions() {
        return this.compatibleVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleVersions() ? this.compatibleVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonCompatibilityDetail)) {
            return false;
        }
        AddonCompatibilityDetail other = (AddonCompatibilityDetail)obj;
        return Objects.equals(this.name(), other.name()) && this.hasCompatibleVersions() == other.hasCompatibleVersions() && Objects.equals(this.compatibleVersions(), other.compatibleVersions());
    }

    public final String toString() {
        return ToString.builder((String)"AddonCompatibilityDetail").add("Name", (Object)this.name()).add("CompatibleVersions", this.hasCompatibleVersions() ? this.compatibleVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "compatibleVersions": {
                return Optional.ofNullable(clazz.cast(this.compatibleVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("compatibleVersions", COMPATIBLE_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddonCompatibilityDetail, T> g) {
        return obj -> g.apply((AddonCompatibilityDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> compatibleVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddonCompatibilityDetail model) {
            this.name(model.name);
            this.compatibleVersions(model.compatibleVersions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCompatibleVersions() {
            if (this.compatibleVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleVersions;
        }

        public final void setCompatibleVersions(Collection<String> compatibleVersions) {
            this.compatibleVersions = StringListCopier.copy(compatibleVersions);
        }

        @Override
        public final Builder compatibleVersions(Collection<String> compatibleVersions) {
            this.compatibleVersions = StringListCopier.copy(compatibleVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleVersions(String ... compatibleVersions) {
            this.compatibleVersions(Arrays.asList(compatibleVersions));
            return this;
        }

        public AddonCompatibilityDetail build() {
            return new AddonCompatibilityDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddonCompatibilityDetail> {
        public Builder name(String var1);

        public Builder compatibleVersions(Collection<String> var1);

        public Builder compatibleVersions(String ... var1);
    }
}

