/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.UserGroup;

public class DescribeUserGroupsPublisher
implements SdkPublisher<DescribeUserGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeUserGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUserGroupsPublisher(ElastiCacheAsyncClient client, DescribeUserGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUserGroupsPublisher(ElastiCacheAsyncClient client, DescribeUserGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUserGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUserGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserGroup> userGroups() {
        Function<DescribeUserGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userGroups() != null) {
                return response.userGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeUserGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeUserGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeUserGroupsResponse> {
        private DescribeUserGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUserGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeUserGroupsResponse> nextPage(DescribeUserGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUserGroupsPublisher.this.client.describeUserGroups(DescribeUserGroupsPublisher.this.firstRequest);
            }
            return DescribeUserGroupsPublisher.this.client.describeUserGroups((DescribeUserGroupsRequest)((Object)DescribeUserGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

